
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
categories = np.arange(2015, 2023, 1)
data = {
    "Email": np.random.randint(200, 400, size=(categories.size)),
    "Social Media": np.random.randint(150, 300, size=(categories.size)),
    "Phone Calls": np.random.randint(100, 250, size=(categories.size)),
    "Video Calls": np.random.randint(50, 200, size=(categories.size)),
}

# Extracted variables
legend_labels = list(data.keys())
xlabel_value = "Year"
ylabel_value = "Usage Frequency"
title_value = "Communication Trends Over Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (2015, 2022)
ylim_values = (0, 1200)
legend_loc = "upper left"
legend_reverse = False
legend_frameon = True
legend_ncol = 1
legend_bbox_to_anchor = (1.02, 1)
title_y_position = 1.05
colors = ["#FFA07A", "#20B2AA", "#778899", "#FFD700"]
fig, ax = plt.subplots(figsize=(12, 6))
ax.stackplot(
    categories,
    data.values(),
    labels=legend_labels,
    alpha=0.85,
    colors=colors,
)
ax.legend(
    loc=legend_loc,
    reverse=legend_reverse,
    frameon=legend_frameon,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)
ax.set_xlim(*xlim_values)
ax.set_ylim(*ylim_values)
ax.set_title(title_value, y=title_y_position, fontsize=18)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.grid(True, linestyle="--", color="grey", alpha=0.7)
ax.tick_params(axis="both", which="major", length=5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_75.pdf", bbox_inches="tight")
