
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(4)
categories = np.arange(1, 6, 1)
data = {
    "Happiness Index": np.random.randint(60, 90, size=(categories.size)),
    "Stress Levels": np.random.randint(40, 80, size=(categories.size)),
    "Cognitive Ability": np.random.randint(70, 100, size=(categories.size)),
    "Social Interaction Levels": np.random.randint(50, 90, size=(categories.size)),
}

# Extracted variables
legend_labels = list(data.keys())
xlabel_value = "Age Group"
ylabel_value = "Score"
title_value = "Psychological Metrics by Age Group"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (1, 5)
ylim_values = (0, 350)
legend_loc = "upper right"
legend_reverse = False
legend_frameon = True
legend_ncol = 1
legend_bbox_to_anchor = (1.1, 1.15)
title_y_position = 1.05
colors = ["#6699CC", "#88CC88", "#CC88CC", "#FFCC99"]
fig, ax = plt.subplots(figsize=(12, 6))
ax.stackplot(
    categories,
    data.values(),
    labels=legend_labels,
    alpha=0.85,
    colors=colors,
)
ax.legend(
    loc=legend_loc,
    reverse=legend_reverse,
    frameon=legend_frameon,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)
ax.set_xlim(*xlim_values)
ax.set_ylim(*ylim_values)
ax.set_title(title_value, y=title_y_position, fontsize=18)
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)
ax.grid(True, linestyle="--", color="grey", alpha=0.7)
ax.tick_params(axis="both", which="major", length=5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_76.pdf", bbox_inches="tight")
