
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the bar chart
genres = range(1, 11)
accuracies = [0.88, 0.76, 0.81, 0.67, 0.79, 0.92, 0.85, 0.8, 0.74, 0.69]
xlabel = "Top-10 Literary Genres in Dataset"
ylabel = "Accuracy"
title = "Accuracy of Classification for Literary Genres"
legend_label = "Average Accuracy"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim = (0.0, 1.1)
yticks = [0.0, 0.2, 0.4, 0.6, 0.8, 1.0]

# Create the bar chart
plt.figure(figsize=(12, 7))  # Adjusting figure size for better readability
plt.bar(genres, accuracies, color="#c96e6e")  # Using a warm color

# Add a horizontal line for the average accuracy
average_accuracy = np.mean(accuracies)
plt.axhline(y=average_accuracy, color="green", linestyle="--", linewidth=2, label=legend_label)

# Add labels and title
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)
plt.title(title, fontsize=16)

# Set y-axis limits
plt.ylim(ylim)

# Set x-axis, y-axis ticks
plt.xticks(genres, labels=["Novel", "Poetry", "Drama", "Short Story", "Mystery", "Non-Fiction", "Fantasy", "Biography", "Essay", "Horror"], rotation=45)
plt.yticks(yticks)

# Add a legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_102.pdf", bbox_inches="tight")
