
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the bar chart
cities = ["City A", "City B", "City C", "City D", "City E", "City F", "City G", "City H", "City I", "City J"]
average_temperatures = [15.0, 18.5, 22.0, 10.0, 25.0, 30.0, 28.5, 12.5, 20.0, 16.0]
xlabel = "Cities"
ylabel = "Average Temperature (°C)"
chart_title = "Average Monthly Temperatures in Different Cities"
annot_text_high = "Highest Temp"
annot_text_low = "Lowest Temp"
legend_label = "Average Temp"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim = (0.0, 35.0)
yticks = np.arange(0, 36, 5)

# Create the bar chart
plt.figure(figsize=(12, 8))  # Adjusting figure size for better readability
bars = plt.bar(cities, average_temperatures, color=plt.cm.coolwarm(np.linspace(0, 1, len(cities))))

# Highlight the highest and lowest bars
highest_temp = max(average_temperatures)
lowest_temp = min(average_temperatures)
highest_idx = average_temperatures.index(highest_temp)
lowest_idx = average_temperatures.index(lowest_temp)

bars[highest_idx].set_color('red')
bars[lowest_idx].set_color('blue')

# Add a horizontal line for the average temperature
average_temp = np.mean(average_temperatures)
plt.axhline(y=average_temp, color="green", linestyle="--", label=legend_label)

# Add annotations for highest and lowest temperatures
plt.text(highest_idx, highest_temp + 1, annot_text_high, ha='center', color='red')
plt.text(lowest_idx, lowest_temp + 1, annot_text_low, ha='center', color='blue')

# Add labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(chart_title)

# Set y-axis limits and grid lines
plt.ylim(ylim)
plt.yticks(yticks)
plt.grid(axis='y', linestyle='--', alpha=0.7)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_103.pdf", bbox_inches="tight")
