
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for the bar chart
eras = range(1, 11)  # Historical eras
accuracy_scores = [0.54, 0.67, 0.73, 0.69, 0.87, 0.55, 0.82, 0.77, 0.66, 0.91]  # Hypothetical historical authenticity scores
xlabel = "Top-10 Historical Eras"
ylabel = "Historical Authenticity Index"
title = "Accuracy of Historical Representation Across Eras"
legend_label = "Average Authenticity Index"

# Calculate the average score
average_score = sum(accuracy_scores) / len(accuracy_scores)

ylim = (0.0, 1.0)
yticks = np.arange(0.0, 1.1, 0.1)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the bar chart
plt.figure(figsize=(10, 6))  # Adjusting figure size to match the original image's dimensions
bars = plt.bar(eras, accuracy_scores, color=["#8b5a2b", "#bc8f8f", "#8fbc8f", "#7cfc00", "#d2691e", "#f4a460", "#556b2f", "#a0522d", "#6b8e23", "#2e8b57"], edgecolor="black", hatch='//')

# Add a horizontal line for the average score
plt.axhline(y=average_score, color="red", linestyle="--", linewidth=2, label=legend_label)

# Add labels and title
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=14)

# Set y-axis limits
plt.ylim(ylim)
# Set x-axis, y-axis ticks
plt.xticks(eras, fontsize=10)
plt.yticks(yticks, fontsize=10)

# Add a legend
plt.legend()

# Add grid lines
plt.grid(True, color='grey', linestyle='--', linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_104.pdf", bbox_inches="tight")
