
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for Region A
region_a_categories = ["Age Group", "Income Level", "Education Level", "Employment Status", "Total Population"]
region_a_2020 = [30, 20, 35, 15, 100]
region_a_2021 = [32, 22, 33, 17, 104]
region_a_2022 = [35, 25, 30, 20, 110]
region_a_2023 = [40, 30, 25, 25, 120]

# Data for Region B
region_b_categories = ["Age Group", "Income Level", "Education Level", "Employment Status", "Total Population"]
region_b_2020 = [25, 18, 40, 17, 100]
region_b_2021 = [28, 20, 37, 20, 105]
region_b_2022 = [30, 24, 34, 22, 110]
region_b_2023 = [35, 28, 30, 30, 120]

xlabel = "Categories"
ylabel = "Population Metrics (%)"
title = "Population Data Over Years"
title_region_a = "Region A"
title_region_b = "Region B"
labels = ["2020", "2021", "2022", "2023"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim = [0, 150]
yticks = np.arange(0, 151, 30)

# Set up the figure and axes
fig, axs = plt.subplots(2, 1, figsize=(10, 8))  # Width, Height in inches

# Plot for Region A
x = np.arange(len(region_a_categories))
width = 0.18  # Adjust this value to change the width of the bars
spacing = 0.2  # Adjust this value to change the spacing between the bars

custom_colors = ["#5386E4", "#E4A953", "#53E45E", "#E45353"]

axs[0].bar(x - spacing * 1.5, region_a_2020, width, label=labels[0], color=custom_colors[0])
axs[0].bar(x - spacing / 2, region_a_2021, width, label=labels[1], color=custom_colors[1])
axs[0].bar(x + spacing / 2, region_a_2022, width, label=labels[2], color=custom_colors[2])
axs[0].bar(x + spacing * 1.5, region_a_2023, width, label=labels[3], color=custom_colors[3])
axs[0].set_title(title_region_a)
axs[0].set_xticks(x)
axs[0].set_xticklabels(region_a_categories)
axs[0].set_ylim(ylim)
axs[0].set_yticks(yticks)
axs[0].legend(loc="upper left")

# Plot for Region B
x = np.arange(len(region_b_categories))
axs[1].bar(x - spacing * 1.5, region_b_2020, width, color=custom_colors[0])
axs[1].bar(x - spacing / 2, region_b_2021, width, color=custom_colors[1])
axs[1].bar(x + spacing / 2, region_b_2022, width, color=custom_colors[2])
axs[1].bar(x + spacing * 1.5, region_b_2023, width, color=custom_colors[3])
axs[1].set_title(title_region_b)
axs[1].set_xticks(x)
axs[1].set_xticklabels(region_b_categories)
axs[1].set_ylim(ylim)
axs[1].set_yticks(yticks)

# Add common labels
fig.text(0.5, -0.01, xlabel, ha='center', fontsize=12)
fig.text(-0.01, 0.5, ylabel, va='center', rotation='vertical', fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_105.pdf", bbox_inches="tight")
