
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for Politician Approval Rates
approval_categories = ["Honesty", "Competence", "Vision", "Charisma", "Total"]
approval_manual_survey = [70, 60, 50, 80, 65]
approval_online_survey = [60, 55, 45, 75, 58]
approval_expert_analysis = [65, 70, 55, 85, 65]
approval_peer_review = [75, 65, 60, 90, 70]

# Data for Policy Agreement Rates
policy_categories = ["Economy", "Healthcare", "Education", "Defense", "Total"]
policy_manual_survey = [60, 70, 65, 55, 63]
policy_online_survey = [55, 65, 60, 50, 58]
policy_expert_analysis = [70, 75, 68, 60, 68]
policy_peer_review = [80, 85, 75, 70, 78]

# Labels
labels = ["Manual Survey", "Online Survey", "Expert Analysis", "Peer Review"]
title = "Approval/Agreement Rate (%)"
title1 = "Politician Approval Rates"
title2 = "Policy Agreement Rates"

# Plot configuration
ylim1 = [0, 100]
yticks1 = np.arange(0, 101, 20)
ylim2 = [0, 100]
yticks2 = np.arange(0, 101, 20)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set up the figure and axes
fig, axs = plt.subplots(2, 1, figsize=(10, 7))  # Width, Height in inches

# Custom colors
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

# Plot for Politician Approval Rates
x = np.arange(len(approval_categories))
width = 0.18  # Adjust this value to change the width of the bars
spacing = 0.2  # Adjust this value to change the spacing between the bars

axs[0].bar(x - spacing * 1.5, approval_manual_survey, width, label=labels[0], color=colors[0])
axs[0].bar(x - spacing / 2, approval_online_survey, width, label=labels[1], color=colors[1])
axs[0].bar(x + spacing / 2, approval_expert_analysis, width, label=labels[2], color=colors[2])
axs[0].bar(x + spacing * 1.5, approval_peer_review, width, label=labels[3], color=colors[3])
axs[0].set_title(title1)
axs[0].set_xticks(x)
axs[0].set_xticklabels(approval_categories)
axs[0].set_ylim(ylim1)
axs[0].set_yticks(yticks1)
axs[0].legend(loc="upper right", ncol=2)

# Plot for Policy Agreement Rates
x = np.arange(len(policy_categories))
axs[1].bar(x - spacing * 1.5, policy_manual_survey, width, color=colors[0])
axs[1].bar(x - spacing / 2, policy_online_survey, width, color=colors[1])
axs[1].bar(x + spacing / 2, policy_expert_analysis, width, color=colors[2])
axs[1].bar(x + spacing * 1.5, policy_peer_review, width, color=colors[3])
axs[1].set_title(title2)
axs[1].set_xticks(x)
axs[1].set_xticklabels(policy_categories)
axs[1].set_ylim(ylim2)
axs[1].set_yticks(yticks2)

# Add a common y-axis label
fig.text(0.0001, 0.5, title, va="center", rotation="vertical", fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_107.pdf", bbox_inches="tight")
