
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for major world religions by percentage
categories = [
    "Christianity",
    "Islam",
    "Secular/Atheism",
    "Hinduism",
    "Buddhism",
    "Chinese Trad. Religion",
    "Ethnic Religions",
    "African Traditional\nand Diaspora",
    "Sikhism",
    "Spiritism"
]
values = [31, 24, 16, 15, 7, 5, 3, 2, 2, 1]

# Plot labels and titles
ylabel = "Adherence (%)"
title = "World Religion Adherence Rates"
xlabel = "Religions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim = (0, 35)
yticks = [0, 5, 10, 15, 20, 25, 30, 35]
xticks = categories  # Assuming xticks are the same as categories
xtickslabel_rotation = 45  # Rotate labels for better readability

# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))  # Width, Height in inches

# Bar chart
colors = [
    "#4c72b0", "#55a868", "#c44e52", "#8172b3", "#ccb974", 
    "#64b5cd", "#8c8c8c", "#e377c2", "#f28123", "#6a3d9a"
]
bars = ax.bar(categories, values, color=colors)

# Set labels and title
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
ax.set_ylim(ylim)
ax.set_yticks(yticks)
ax.tick_params(axis="both", which="both", length=0)

# Rotate x-axis labels
plt.xticks(ticks=xticks, rotation=xtickslabel_rotation, ha="right")

# Hide the border
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# Add gridlines for better readability
ax.yaxis.grid(True, which='major', linestyle='--', linewidth=0.7, color='gray', alpha=0.7)

# Annotations to highlight key points
for bar in bars:
    height = bar.get_height()
    ax.annotate(f'{height}%', 
                xy=(bar.get_x() + bar.get_width() / 2, height),
                xytext=(0, 3),  # 3 points vertical offset
                textcoords="offset points",
                ha='center', va='bottom')

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_108.pdf", bbox_inches="tight")
