
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
subjects = [
    "Math",
    "Science",
    "English",
    "History",
    "Geography",
    "Art",
    "Music",
    "PE",
    "IT",
    "Literature"
]
average_scores = [78, 82, 85, 75, 80, 88, 90, 70, 95, 87]

# Plot labels and titles
ylabel = "Average Score (%)"
xlabel = "Subjects"
title = "Average Student Scores by Subject"
legend_label = "Average Score"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim = (60, 100)
yticks = range(60, 101, 10)
xticks = subjects  # Assuming xticks are the same as subjects
xtickslabel_rotation = 45  # Rotate x-axis labels for readability

# Colors
bar_colors = "#1f77b4"

# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))  # Width, Height in inches

# Bar chart with customizations
bars = ax.bar(subjects, average_scores, color=bar_colors, edgecolor='black', alpha=0.7)

# Set labels and title
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
ax.set_ylim(ylim)
ax.set_yticks(yticks)
ax.tick_params(axis="x", rotation=xtickslabel_rotation)

# Add gridlines for better readability
ax.yaxis.grid(True)
ax.xaxis.grid(False)

# Hide the border
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# Add annotation labels on the bars
for bar in bars:
    height = bar.get_height()
    ax.annotate(f'{height}%', xy=(bar.get_x() + bar.get_width() / 2, height),
                xytext=(0, 3),  # 3 points vertical offset
                textcoords="offset points",
                ha='center', va='bottom')

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_109.pdf", bbox_inches="tight")
