
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
categories = ["18-29", "30-44", "45-59", "60-74", "75+"]
values = [0.70, -0.60, -0.45, 0.50, -0.25]

# Plot configuration variables
ylabel = "Approval Rating (%)"
xlabel = "Age Group"
title = "Political Leader Approval Ratings by Age Group"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim = (-0.5, 4.5)
ylim = (-1, 1)
yticks = [-1.00, -0.75, -0.5, -0.25, 0, 0.25, 0.50, 0.75, 1.0]

# Create the figure and the bar chart
fig, ax = plt.subplots(figsize=(8, 6))
bars = ax.bar(categories, values, color=["#4f81bd" if val >= 0 else "#c0504d" for val in values], edgecolor="white", width=0.6, zorder=3)

# Set labels and title
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title, fontsize=14, fontweight='bold')
ax.set_xlim(xlim)
ax.set_ylim(ylim)
ax.tick_params(axis="y", which="both", length=0)
ax.tick_params(axis="x", which="both", length=0)
ax.set_yticks(yticks)
ax.set_facecolor("#eaeaf2")  # Set the axes background color
ax.yaxis.grid(True, color="white", zorder=2)  # Add grid lines

# Remove the border around the chart area
for spine in ax.spines.values():
    spine.set_visible(False)

# Ensure that the bars for negative values start from zero
for bar in bars:
    if bar.get_height() < 0:
        bar.set_y(0)

# Add padding around the chart
plt.subplots_adjust(left=0.15, right=0.95, top=0.9, bottom=0.15)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("bar_111.pdf", bbox_inches="tight")
