
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for the plots
therapies = ["CBT", "EMDR", "DBT", "Mindfulness", "Psychoanalysis"]
general_anxiety_reduction = [35, 45, 25, 20, 15]
social_anxiety_reduction = [40, 30, 50, 45, 10]
performance_anxiety_reduction = [50, 30, 40, 35, 20]

title1 = "General Anxiety Reduction"
axvline1 = 0
title2 = "Social Anxiety Reduction"
axvline2 = 0
title3 = "Performance Anxiety Reduction"
axvline3 = 0

xlabel = "Reduction in Anxiety (%)"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks1 = [0, 20, 40, 60]
xticks2 = [0, 20, 40, 60]
xticks3 = [0, 20, 40, 60]

# Labels for annotations
annotation_color_positive = "#000000"
annotation_color_negative = "#FF0000"

# Set the figure size to match the original image's dimensions
fig, axes = plt.subplots(1, 3, figsize=(15, 6))

# Define colors for the bars
bar_colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd"]

# Plot for General Anxiety
axes[0].barh(therapies, general_anxiety_reduction, color=bar_colors, edgecolor="black")
axes[0].set_title(title1)
for i, v in enumerate(general_anxiety_reduction):
    axes[0].text(
        v + 2,
        i,
        f"{v}%",
        color=annotation_color_positive,
        va="center",
        ha="left",
    )
axes[0].axvline(axvline1, color="black")

# Plot for Social Anxiety
axes[1].barh(therapies, social_anxiety_reduction, color=bar_colors, edgecolor="black")
axes[1].set_title(title2)
for i, v in enumerate(social_anxiety_reduction):
    axes[1].text(
        v + 2,
        i,
        f"{v}%",
        color=annotation_color_positive,
        va="center",
        ha="left",
    )
axes[1].axvline(axvline2, color="black")
axes[1].set_xticks(xticks1)

# Plot for Performance Anxiety
axes[2].barh(therapies, performance_anxiety_reduction, color=bar_colors, edgecolor="black")
axes[2].set_title(title3)
for i, v in enumerate(performance_anxiety_reduction):
    axes[2].text(
        v + 2,
        i,
        f"{v}%",
        color=annotation_color_positive,
        va="center",
        ha="left",
    )
axes[2].axvline(axvline3, color="black")
axes[2].set_xticks(xticks2)

# Hide all axes except the bottom one
for ax in axes:
    for spine in ["left", "right", "top"]:
        ax.spines[spine].set_visible(False)

# Hide y-axis labels for axes[1] and axes[2]
axes[1].set_yticks([])
axes[1].set_yticklabels([])
axes[2].set_yticks([])
axes[2].set_yticklabels([])

# Add x-axis label for all axes
for ax in axes:
    ax.set_xlabel(xlabel)

plt.subplots_adjust(wspace=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_114.pdf", bbox_inches="tight")
