
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the plots
models = ["Model A", "Model B", "Model C", "Model D", "Model E"]
wheat_yield = [25.3, 30.1, 20.4, 18.2, 22.5]
corn_yield = [32.4, 33.1, 28.7, 31.3, 29.5]
soybean_yield = [15.2, 20.9, 18.4, 17.8, 19.1]

title1 = "Wheat Yield"
axvline1 = 0
title2 = "Corn Yield"
axvline2 = 0
title3 = "Soybean Yield"
axvline3 = 0

xlabel = "Yield (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks1 = [0, 10, 20, 30, 40]
xticks2 = [0, 10, 20, 30, 40]
xticks3 = [0, 10, 20, 30, 40]

# Set the figure size to match the original image's dimensions
fig, axes = plt.subplots(1, 3, figsize=(12, 5))

# Color configurations
wheat_color = "#7FBF7F"  # Light Green
corn_color = "#FFD700"   # Yellow
soybean_color = "#8B4513" # Brown

# Plot for Wheat Yield
axes[0].barh(models, wheat_yield, color=wheat_color, edgecolor="black")
axes[0].set_title(title1)
for i, v in enumerate(wheat_yield):
    axes[0].text(
        v + 0.5,
        i,
        f"{v}%",
        color="black",
        va="center",
        ha="left",
    )
axes[0].axvline(axvline1, color="black")
axes[0].set_xticks(xticks1)

# Plot for Corn Yield
axes[1].barh(models, corn_yield, color=corn_color, edgecolor="black")
axes[1].set_title(title2)
for i, v in enumerate(corn_yield):
    axes[1].text(
        v + 0.5,
        i,
        f"{v}%",
        color="black",
        va="center",
        ha="left",
    )
axes[1].axvline(axvline2, color="black")
axes[1].set_xticks(xticks2)

# Plot for Soybean Yield
axes[2].barh(models, soybean_yield, color=soybean_color, edgecolor="black")
axes[2].set_title(title3)
for i, v in enumerate(soybean_yield):
    axes[2].text(
        v + 0.5,
        i,
        f"{v}%",
        color="black",
        va="center",
        ha="left",
    )
axes[2].axvline(axvline3, color="black")
axes[2].set_xticks(xticks3)

# Hide all axes except the bottom one
for ax in axes:
    for spine in ["left", "right", "top"]:
        ax.spines[spine].set_visible(False)

# Hide y-axis labels for axes[1] and axes[2]
axes[1].set_yticks([])
axes[1].set_yticklabels([])
axes[2].set_yticks([])
axes[2].set_yticklabels([])

# Add x-axis label for all axes
for ax in axes:
    ax.set_xlabel(xlabel)

plt.subplots_adjust(wspace=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_115.pdf", bbox_inches="tight")
