
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for the plots
models = ["Model A", "Model B", "Model C", "Model D", "Model E"]
north_america_values = [25.4, 18.2, 12.8, 5.7, 30.5]
europe_values = [20.3, 25.6, 15.4, 10.1, 28.7]
asia_values = [35.7, 28.8, 18.7, 8.2, 40.3]

title1 = "North America"
axvline1 = 0
title2 = "Europe"
axvline2 = 0
title3 = "Asia"
axvline3 = 0

xlabel = "Performance (%)"
supertitle = "Product Performance Across Regions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks = [
    np.arange(0, 41, 10),    # North America
    np.arange(0, 31, 10),    # Europe
    np.arange(0, 51, 10)     # Asia
]

# Set the figure size to enhance readability and appearance
fig, axes = plt.subplots(1, 3, figsize=(12, 6))

# Define colors for each region
colors = ["#1f77b4", "#2ca02c", "#ff7f0e"]  # Blue, Green, Orange

# Plot for North America
axes[0].barh(models, north_america_values, color=colors[0])
axes[0].set_title(title1)
for i, v in enumerate(north_america_values):
    axes[0].text(
        v + 0.5, i, f"{v}%", color="black", va="center", ha="left"
    )
axes[0].axvline(axvline1, color="black")

# Plot for Europe
axes[1].barh(models, europe_values, color=colors[1])
axes[1].set_title(title2)
for i, v in enumerate(europe_values):
    axes[1].text(
        v + 0.5, i, f"{v}%", color="black", va="center", ha="left"
    )
axes[1].axvline(axvline2, color="black")

# Plot for Asia
axes[2].barh(models, asia_values, color=colors[2])
axes[2].set_title(title3)
for i, v in enumerate(asia_values):
    axes[2].text(
        v + 0.5, i, f"{v}%", color="black", va="center", ha="left"
    )
axes[2].axvline(axvline3, color="black")

# Set xticks
axes[0].set_xticks(xticks[0])
axes[1].set_xticks(xticks[1])
axes[2].set_xticks(xticks[2])

# Hide all axes except the bottom one
for ax in axes:
    for spine in ["left", "right", "top"]:
        ax.spines[spine].set_visible(False)

# Hide y-axis labels for axes[1] and axes[2]
axes[1].set_yticks([])
axes[1].set_yticklabels([])
axes[2].set_yticks([])
axes[2].set_yticklabels([])

# Add x-axis label for all axes
for ax in axes:
    ax.set_xlabel(xlabel)

fig.suptitle(supertitle, fontsize=16)
plt.subplots_adjust(wspace=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_116.pdf", bbox_inches="tight")
