
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
fertilization_methods = ["Organic", "Chemical", "Organic", "Chemical"]
crops = ["Wheat", "Corn", "Barley", "Soy"]
improvements = {
    "Wheat": [5.6, 2.2, 3.1, 4.2],
    "Corn": [3.4, 3.8, -0.5, 2.1],
    "Barley": [4.9, 1.1, -1.2, 3.3],
    "Soy": [3.7, 2.9, 1.4, 4.4],
}

xlabel = "Fertilization Technique"
ylabel = "Yield Improvement [%]"
legendtitle = "Crop Type"
title = "Crop Yield Improvements with Different Fertilization Methods"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Figure and axis
fig, ax = plt.subplots(figsize=(10, 6))
# Colors for each crop type
colors = ["#4CAF50", "#FFEB3B", "#FF9800", "#795548"]

# Bar width
bar_width = 0.15

# Positions of the bars on the x-axis
r = np.arange(len(fertilization_methods))

for i, crop in enumerate(crops):
    # Plot bars
    bars = plt.bar(
        r,
        improvements[crop],
        color=colors[i],
        hatch="//",
        width=bar_width,
        edgecolor="white",
        label=crop,
    )
    # Add text labels
    for bar, val in zip(bars, improvements[crop]):
        height = bar.get_height()
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            height + (0.1 if val > 0 else -0.4),
            str(val),
            ha="center",
        )

    # Move the position for the next set of bars
    r = [x + bar_width for x in r]

# Add xticks on the middle of the group bars
plt.xlabel(xlabel)
plt.xticks([r + bar_width * 2 for r in range(len(fertilization_methods))], fertilization_methods)

# Add ylabel
plt.ylabel(ylabel)

plt.gca().grid(color="gray", linewidth=0.5)
plt.gca().set_axisbelow(True)

# Create legend & Show graphic
plt.legend(title=legendtitle, bbox_to_anchor=(0.5, 1), loc="upper center", ncol=3)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_118.pdf", bbox_inches="tight")
