
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data
models = ["Tech-X", "Innovator-Y", "Tech-X", "Innovator-Y"]
languages = ["Python", "JavaScript", "Java", "C++", "Ruby"]
improvements = {
    "Python": [5.1, 2.2, 3.8, 4.6],
    "JavaScript": [4.9, 3.1, 2.3, 4.4],
    "Java": [3.7, 1.9, 1.0, 3.3],
    "C++": [2.4, 0.5, -1.2, 2.0],
    "Ruby": [3.0, -0.3, -2.5, 1.2],
}

xlabel = "Model"
ylabel = "Improvement [%]"
legendtitle = "Programming Language"
title = "Technology Model Performance Improvements"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors for each language
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd"]

# Figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Bar width
bar_width = 0.15

# Positions of the bars on the x-axis
r = np.arange(len(models))

for i, language in enumerate(languages):
    # Plot bars
    bars = plt.bar(
        r,
        improvements[language],
        color=colors[i],
        width=bar_width,
        edgecolor="white",
        label=language,
    )
    # Add text labels
    for bar, val in zip(bars, improvements[language]):
        height = bar.get_height()
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            height + (0.1 if val > 0 else -0.4),
            str(val),
            ha="center",
            fontsize=10,
        )

    # Move the position for the next set of bars
    r = [x + bar_width for x in r]
# Add xticks on the middle of the group bars
plt.xlabel(xlabel, fontsize=12)
plt.xticks([r + bar_width * 2 for r in range(len(models))], models)

# Add ylabel
plt.ylabel(ylabel, fontsize=12)

plt.gca().grid(color="gray", linewidth=0.5, linestyle='--')
plt.gca().set_axisbelow(True)

# Create legend & Show graphic
plt.legend(title=legendtitle, bbox_to_anchor=(0.5, 1), loc="upper center", ncol=3)
plt.title(title, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_119.pdf", bbox_inches="tight")
