
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
labels = ["USA", "China", "India", "Germany", "France", "Brazil"]
year_2018 = [16.2, 7.5, 2.1, 9.7, 5.2, 2.6]
year_2019 = [16.1, 7.4, 2.2, 9.6, 5.1, 2.7]
year_2020 = [15.8, 7.3, 2.3, 9.4, 5.0, 2.8]

x = np.arange(len(labels))  # the label locations
width = 0.25  # the width of the bars

# Variables for plot configuration
ylabel = "CO2 Emissions (tons per capita)"
xlabel_co2_wts = "World Trends Study"
xlabel_co2_inv = "Investigation Data"

legend_label_2018 = "2018"
legend_label_2019 = "2019"
legend_label_2020 = "2020"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks = x
xticklabels = labels
ylim_ax1 = (0, 20)
ylim_ax2 = (0, 20)
yticks_ax1 = np.arange(0, 21, 5)
yticks_ax2 = np.arange(0, 21, 5)

# Setting up the figure and axes for a 2 x 1 layout
fig, (ax1, ax2) = plt.subplots(
    2, 1, figsize=(10, 8), gridspec_kw={"height_ratios": [1, 1], "hspace": 0.3}
)

# Upper plot
rects1 = ax1.bar(
    x - width - 0.04,
    year_2018,
    width,
    label=legend_label_2018,
    color="#6baed6",
    edgecolor="black",
)
rects2 = ax1.bar(
    x, year_2019, width, label=legend_label_2019, color="#31a354", edgecolor="black"
)
rects3 = ax1.bar(
    x + width + 0.04,
    year_2020,
    width,
    label=legend_label_2020,
    color="#c994c7",
    edgecolor="black",
)
# Lower plot
rects4 = ax2.bar(
    x - width - 0.04, year_2018, width, color="#6baed6", edgecolor="black"
)
rects5 = ax2.bar(x, year_2019, width, color="#31a354", edgecolor="black")
rects6 = ax2.bar(
    x + width + 0.04, year_2020, width, color="#c994c7", edgecolor="black"
)

# Add some text for labels, title and custom x-axis tick labels, etc.
ax1.set_ylabel(ylabel)
ax2.set_ylabel(ylabel)
ax1.set_xlabel(xlabel_co2_wts)
ax2.set_xlabel(xlabel_co2_inv)
ax1.set_xticks(xticks)
ax1.set_xticklabels(xticklabels)
ax2.set_xticks(xticks)
ax2.set_xticklabels(xticklabels)
ax1.legend(loc="upper center", bbox_to_anchor=(0.5, 1.25), ncol=3, frameon=False)

# Set y-axis limit to match the reference picture
ax1.set_ylim(ylim_ax1)
ax2.set_ylim(ylim_ax2)
ax1.tick_params(axis="x", which="both", length=0)
ax2.tick_params(axis="x", which="both", length=0)
ax1.set_yticks(yticks_ax1)
ax2.set_yticks(yticks_ax2)

# Set grid color and style
ax1.grid(axis="y", color="gray", linestyle="--", linewidth=0.5)
ax2.grid(axis="y", color="gray", linestyle="--", linewidth=0.5)
ax1.tick_params(axis="y", which="major", color="gray")
ax2.tick_params(axis="y", which="major", color="gray")
ax1.set_axisbelow(True)
ax2.set_axisbelow(True)

# Remove top and right borders
ax1.spines["top"].set_visible(False)
ax1.spines["right"].set_visible(False)
ax1.spines["bottom"].set_visible(False)
ax1.spines["left"].set_color("gray")
ax2.spines["top"].set_visible(False)
ax2.spines["right"].set_visible(False)
ax2.spines["bottom"].set_visible(False)
ax2.spines["left"].set_color("gray")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_121.pdf", bbox_inches="tight")
