
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
labels = ["USA", "Canada", "UK", "Germany", "France", "Australia"]
urban = [6.8, 7.2, 6.9, 7.1, 6.5, 7.0]
rural = [7.0, 7.5, 7.2, 6.8, 7.3, 6.9]
suburban = [7.1, 7.3, 7.0, 6.9, 7.2, 7.1]

x = np.arange(len(labels))  # the label locations
width = 0.25  # the width of the bars

# Variables for plot configuration
ylabel = "Happiness Index"
xlabel_survey1 = "Survey 1"
xlabel_survey2 = "Survey 2"

legend_label_urban = "Urban"
legend_label_rural = "Rural"
legend_label_suburban = "Suburban"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks = x
xticklabels = labels
ylim_ax1 = (6.4, 7.6)
ylim_ax2 = (6.5, 7.7)
yticks_ax1 = [6.4, 6.6, 6.8, 7.0, 7.2, 7.4, 7.6]
yticks_ax2 = [6.5, 6.7, 6.9, 7.1, 7.3, 7.5, 7.7]
# Setting up the figure and axes for a 2 x 1 layout
fig, (ax1, ax2) = plt.subplots(
    2, 1, figsize=(8, 6), gridspec_kw={"height_ratios": [1, 1], "hspace": 0.3}
)

# Upper plot
rects1 = ax1.bar(
    x - width - 0.04,
    urban,
    width,
    label=legend_label_urban,
    color="#4c72b0",
    edgecolor="black",
)
rects2 = ax1.bar(
    x, rural, width, label=legend_label_rural, color="#55a868", edgecolor="black"
)
rects3 = ax1.bar(
    x + width + 0.04,
    suburban,
    width,
    label=legend_label_suburban,
    color="#c44e52",
    edgecolor="black"
)
# Lower plot
rects4 = ax2.bar(
    x - width - 0.04, urban, width, color="#4c72b0", edgecolor="black"
)
rects5 = ax2.bar(x, rural, width, color="#55a868", edgecolor="black")
rects6 = ax2.bar(
    x + width + 0.04, suburban, width, color="#c44e52", edgecolor="black"
)

# Add some text for labels, title and custom x-axis tick labels, etc.
ax1.set_ylabel(ylabel)
ax2.set_ylabel(ylabel)
ax1.set_xlabel(xlabel_survey1)
ax2.set_xlabel(xlabel_survey2)
ax1.set_xticks(xticks)
ax1.set_xticklabels(xticklabels)
ax2.set_xticks(xticks)
ax2.set_xticklabels(xticklabels)
ax1.legend(loc="upper center", bbox_to_anchor=(0.5, 1.25), ncol=3, frameon=False)

# Set y-axis limit to match the reference picture
ax1.set_ylim(ylim_ax1)
ax2.set_ylim(ylim_ax2)
ax1.tick_params(axis="x", which="both", length=0)
ax2.tick_params(axis="x", which="both", length=0)
ax1.set_yticks(yticks_ax1)
ax2.set_yticks(yticks_ax2)

# Set grid color and style
ax1.grid(axis="y", color="gray", linestyle="--", linewidth=0.5)
ax2.grid(axis="y", color="gray", linestyle="--", linewidth=0.5)
ax1.tick_params(axis="y", which="major", color="gray")
ax2.tick_params(axis="y", which="major", color="gray")
ax1.set_axisbelow(True)
ax2.set_axisbelow(True)

# Remove top and right borders
ax1.spines["top"].set_visible(False)
ax1.spines["right"].set_visible(False)
ax1.spines["bottom"].set_visible(False)
ax1.spines["left"].set_color("gray")
ax2.spines["top"].set_visible(False)
ax2.spines["right"].set_visible(False)
ax2.spines["bottom"].set_visible(False)
ax2.spines["left"].set_color("gray")

# Set supertitle
fig.suptitle('Happiness Index Comparison by Demographic Groups')

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_122.pdf", bbox_inches="tight")
