
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the plots
roles = ["Treatment A", "Treatment B", "Treatment C"]
counts_s1 = np.array([[120, 180, 400], [140, 260, 300], [160, 380, 160]])
counts_s2 = np.array([[130, 200, 370], [120, 280, 300], [180, 340, 180]])

# Variables for plot configuration
xlabel_value = "Number of Patients"
ylabel_value = "Treatment Type"
title_s1 = "Scenario 1: Patient Outcomes"
title_s2 = "Scenario 2: Patient Outcomes"
legend_labels = ["Responders", "Non-responders", "Partially Responders"]
fig_title = "Patient Response by Treatment Type"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors for the bars
colors = ["#76c7c0", "#ffb347", "#ffa07a"]
width = 0.3
xlim_value = (0, 800)
xticks_value = [0, 100, 200, 300, 400, 500, 600, 700, 800]
yticks_value = roles
fontsize_title = 16

# Create subplots with shared x-axis
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 8), sharex=True)

# Function to plot stacked bars
def plot_stacked_bars(ax, counts, roles, colors):
    bottom = np.zeros(len(roles))
    for i in range(counts.shape[1]):
        ax.barh(
            roles, counts[:, i], height=width, zorder=5, left=bottom, color=colors[i]
        )
        bottom += counts[:, i]

# Plot for Scenario 1
plot_stacked_bars(ax1, counts_s1, roles, colors)
ax1.set_title(title_s1, y=1.2)
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value)
ax1.invert_yaxis()  # Invert y-axis to match the picture
ax1.grid(True, alpha=0.7, linestyle='--')  # Add grid lines with dashed lines
ax1.set_xlim(*xlim_value)
ax1.tick_params(axis="y", which="both", length=0)
ax1.tick_params(axis="x", which="both", color="gray")

# Plot for Scenario 2
plot_stacked_bars(ax2, counts_s2, roles, colors)
ax2.set_title(title_s2)
ax2.set_xlabel(xlabel_value)
ax2.set_ylabel(ylabel_value)
ax2.set_xlim(*xlim_value)
ax2.invert_yaxis()  # Invert y-axis to match the picture
ax2.grid(True, alpha=0.7, linestyle='--')  # Add grid lines with dashed lines
ax2.tick_params(axis="y", which="both", length=0)
ax2.tick_params(axis="x", which="both", color="gray")

# Legend
ax1.legend(
    legend_labels,
    bbox_to_anchor=(0.5, 1.2),
    loc="upper center",
    ncol=3,
    frameon=False,
)

# Set x-axis ticks after all plots
ax1.set_xticks(xticks_value)
ax2.set_xticks(xticks_value)
ax1.tick_params(axis="x", which="both", bottom=True, top=False, labelbottom=True)

# Title for the whole figure
fig.suptitle(fig_title, fontsize=fontsize_title)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("bar_127.pdf", bbox_inches="tight")
