
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
genres = ["Drama", "Comedy", "Action", "Sci-Fi", "Average"]
Netflix = [86.0, 78.2, 90.3, 82.1, 84.2]
Amazon_Prime = [84.3, 76.6, 88.5, 81.4, 82.7]
Disney_Plus = [89.4, 80.5, 85.6, 90.2, 86.4]
HBO_Max = [87.2, 77.3, 82.0, 85.8, 83.1]
Hulu = [85.4, 79.1, 86.7, 80.0, 82.8]

# Plot labels
xlabel = "Genres"
ylabel = "Average Rating (%)"
title = "Average Ratings of Streaming Services by Genre"

# Legend labels
Netflix_label = "Netflix"
Amazon_Prime_label = "Amazon Prime"
Disney_Plus_label = "Disney Plus"
HBO_Max_label = "HBO Max"
Hulu_label = "Hulu"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
barWidth = 0.16
xticks = [r + barWidth * 2 for r in range(len(Netflix))]
xtickslabel = genres
yticks = [60, 65, 70, 75, 80, 85, 90, 95, 100]
ytickslabel = None
xlim = None
ylim = (60, 100)

# Set figure size to match the original image's dimensions
plt.figure(figsize=(10, 5))

# Set position of bar on X axis
r1 = np.arange(len(Netflix))
r2 = [x + barWidth for x in r1]
r3 = [x + barWidth for x in r2]
r4 = [x + barWidth for x in r3]
r5 = [x + barWidth for x in r4]

# Make the plot
plt.bar(
    r1,
    Netflix,
    color="#FF6F61",
    width=barWidth,
    edgecolor="white",
    label=Netflix_label,
)
plt.bar(
    r2,
    Amazon_Prime,
    color="#6B5B95",
    width=barWidth,
    edgecolor="white",
    label=Amazon_Prime_label,
)
plt.bar(
    r3,
    Disney_Plus,
    color="#88B04B",
    width=barWidth,
    edgecolor="white",
    label=Disney_Plus_label,
)
plt.bar(
    r4,
    HBO_Max,
    color="#FFA07A",
    width=barWidth,
    edgecolor="white",
    label=HBO_Max_label,
)
plt.bar(
    r5,
    Hulu,
    color="#0E4D92",
    width=barWidth,
    edgecolor="white",
    label=Hulu_label,
)

# Add labels
for i in range(len(genres)):
    plt.text(
        r1[i],
        Netflix[i] + 1,
        str(Netflix[i]),
        ha="center",
        fontsize=6,
        rotation=45,
    )
    plt.text(
        r2[i],
        Amazon_Prime[i] + 1,
        str(Amazon_Prime[i]),
        ha="center",
        fontsize=6,
        rotation=45,
    )
    plt.text(
        r3[i],
        Disney_Plus[i] + 1,
        str(Disney_Plus[i]),
        ha="center",
        fontsize=6,
        rotation=45,
    )
    plt.text(
        r4[i],
        HBO_Max[i] + 1,
        str(HBO_Max[i]),
        ha="center",
        fontsize=6,
        rotation=45,
    )
    plt.text(
        r5[i],
        Hulu[i] + 1,
        str(Hulu[i]),
        ha="center",
        fontsize=6,
        rotation=45,
    )

# Add xticks on the middle of the group bars
plt.xlabel(xlabel, fontsize=12)
plt.xticks(xticks, xtickslabel)

# Create legend & Show graphic
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=14)
plt.ylim(ylim)
plt.yticks(yticks)
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), frameon=False, ncol=5)

plt.tick_params(axis="x", which="both", length=0)
plt.tick_params(axis="y", color="gray")

# Add y grid
plt.gca().yaxis.grid(True)
plt.gca().set_axisbelow(True)

# Remove top and right borders
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["bottom"].set_visible(False)
plt.gca().spines["left"].set_color("gray")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_131.pdf", bbox_inches="tight")
