
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
campaigns = ["Facebook", "Instagram", "Twitter"]
jan = [70, 50, 80]
feb = [75, 52, 78]
mar = [78, 60, 75]
apr = [80, 65, 70]
may = [85, 68, 72]

barWidth = 0.15
r1 = np.arange(len(jan))
r2 = [x + barWidth for x in r1]
r3 = [x + barWidth for x in r2]
r4 = [x + barWidth for x in r3]
r5 = [x + barWidth for x in r4]

labels = ["January", "February", "March", "April", "May"]
ylabel = "Reach (in thousands)"
title = "Monthly Reach of Media Campaigns"

ylim = [45, 90]
yticks = [45, 50, 55, 60, 65, 70, 75, 80, 85, 90]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure
plt.figure(figsize=(10, 6))

# Create bars with new color scheme
plt.bar(r1, jan, color="#e63946", width=barWidth, edgecolor="black", alpha=0.8, label=labels[0])
plt.bar(r2, feb, color="#f77f00", width=barWidth, edgecolor="black", alpha=0.8, label=labels[1])
plt.bar(r3, mar, color="#a8dadc", width=barWidth, edgecolor="black", alpha=0.8, label=labels[2])
plt.bar(r4, apr, color="#457b9d", width=barWidth, edgecolor="black", alpha=0.8, label=labels[3])
plt.bar(r5, may, color="#1d3557", width=barWidth, edgecolor="black", alpha=0.8, label=labels[4])

# Add xticks on the middle of the group bars
plt.xticks([r + barWidth * 2 for r in range(len(jan))], campaigns)

# Create legend & Show graphic
plt.legend(loc="upper left")
plt.ylabel(ylabel)
plt.title(title)
plt.ylim(ylim)
plt.yticks(yticks)
plt.grid(axis='y', linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_132.pdf", bbox_inches="tight")
