
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
subjects = ["Math", "Science", "English"]
sem1_grades = [88, 92, 85]
sem2_grades = [90, 85, 88]
sem3_grades = [85, 87, 90]
sem4_grades = [87, 90, 85]
sem5_grades = [90, 93, 88]

barWidth = 0.15
r1 = np.arange(len(sem1_grades))
r2 = [x + barWidth for x in r1]
r3 = [x + barWidth for x in r2]
r4 = [x + barWidth for x in r3]
r5 = [x + barWidth for x in r4]

# Labels
labels = ["Semester 1", "Semester 2", "Semester 3", "Semester 4", "Semester 5"]
ylabel = "Average Grade (%)"
xlabel = "Subjects"
title = "Student Grades Across Subjects Over Five Semesters"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim = [80, 100]
yticks = [80, 85, 90, 95, 100]

# Create figure
plt.figure(figsize=(10, 6))

# Create bars
plt.bar(r1, sem1_grades, color="#FF9999", width=barWidth, edgecolor="black", label=labels[0])
plt.bar(r2, sem2_grades, color="#66B2FF", width=barWidth, edgecolor="black", label=labels[1])
plt.bar(r3, sem3_grades, color="#99FF99", width=barWidth, edgecolor="black", label=labels[2])
plt.bar(r4, sem4_grades, color="#FFCC66", width=barWidth, edgecolor="black", label=labels[3])
plt.bar(r5, sem5_grades, color="#B266FF", width=barWidth, edgecolor="black", label=labels[4])

# Add xticks on the middle of the group bars
plt.xticks([r + barWidth * 2 for r in range(len(sem1_grades))], subjects)

# Add gridlines for better readability
plt.grid(axis='y', linestyle='--', alpha=0.7)

# Create legend & Show graphic
plt.legend(loc="upper left")
plt.ylabel(ylabel)
plt.xlabel(xlabel)
plt.title(title)
plt.ylim(ylim)
plt.yticks(yticks)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_133.pdf", bbox_inches="tight")
