
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
categories = [
    "18-24 years",
    "25-34 years",
    "35-44 years",
    "45-54 years",
    "55-64 years",
    "65+ years",
]
satisfied = [65.2, 54.1, 47.6, 39.7, 31.5, 28.9]
neutral = [18.8, 22.3, 28.4, 32.1, 35.7, 39.2]
dissatisfied = [16.0, 23.6, 24.0, 28.2, 32.8, 31.9]
textcontent = "Public Opinion on Climate Change Policies by Age Group"
legendlabels = ["Satisfied", "Neutral", "Dissatisfied"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors
colors = ["#2D7A2C", "#6BAED6", "#E6550D"]

# Plot
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusted figure size

bar_width = 0.6  # Adjusted bar width for tighter layout
bar_spacing = 0.15  # Adjusted spacing between bars

for i, category in enumerate(categories):
    ax.barh(category, satisfied[i], height=bar_width, color=colors[0])
    ax.barh(category, neutral[i], height=bar_width, left=satisfied[i], color=colors[1])
    ax.barh(
        category,
        dissatisfied[i],
        height=bar_width,
        left=satisfied[i] + neutral[i],
        color=colors[2],
    )
    ax.text(
        5,
        category,
        f"{satisfied[i]}%",
        ha="center",
        va="center",
        color="white",
        fontsize=10,
    )
    ax.text(
        satisfied[i] + neutral[i] / 2,
        category,
        f"{neutral[i]}%",
        ha="center",
        va="center",
        color="white",
        fontsize=10,
    )
    ax.text(
        95,
        category,
        f"{dissatisfied[i]}%",
        ha="center",
        va="center",
        color="white",
        fontsize=10,
    )

# Remove spines
ax.spines["right"].set_visible(False)
ax.spines["top"].set_visible(False)
ax.spines["bottom"].set_visible(False)
ax.spines["left"].set_visible(False)

# Remove x-axis
ax.xaxis.set_visible(False)
# Adjust y-axis
ax.invert_yaxis()

# Add label below the x-axis
plt.figtext(
    0.6,
    0.01,
    textcontent,
    ha="center",
    fontsize=10,
)

# Legend
ax.legend(
    legendlabels,
    loc="upper center",
    ncol=3,
    fontsize=12,
    bbox_to_anchor=(0.5, 1.05),
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_136.pdf", bbox_inches="tight")
