
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
categories = ["New York", "Los Angeles", "Chicago", "Houston", "Phoenix"]
high_growth = [75, 50, 40, 60, 70]
moderate_growth = [15, 30, 35, 25, 20]
low_growth = [10, 20, 25, 15, 10]

indices = range(len(categories))

# Text labels for the chart
xlabel = "Population Growth (%)"
ylabel = "Cities"
title = "Population Growth Trends Across Cities"
legend_labels = ["High Growth", "Moderate Growth", "Low Growth"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
bar_width = 0.5

# Figure size
fig, ax = plt.subplots(figsize=(10, 6))

# Bar chart
bars1 = ax.barh(indices, high_growth, bar_width, label=legend_labels[0], color="#2ca02c")
bars2 = ax.barh(indices, moderate_growth, bar_width, left=high_growth, label=legend_labels[1], color="#ff7f0e")
bars3 = ax.barh(indices, low_growth, bar_width, left=[i + j for i, j in zip(high_growth, moderate_growth)], label=legend_labels[2], color="#d62728")

# Adding text labels with positions and font size
for i, bar in enumerate(bars1):
    ax.text(bar.get_width() / 2, bar.get_y() + bar.get_height() / 2, f"{high_growth[i]}%", ha="center", va="center", color="white", fontsize=14)
for i, bar in enumerate(bars2):
    ax.text(bar.get_x() + bar.get_width() / 2, bar.get_y() + bar.get_height() / 2, f"{moderate_growth[i]}%", ha="center", va="center", color="black", fontsize=14)
for i, bar in enumerate(bars3):
    ax.text(bar.get_x() + bar.get_width() / 2, bar.get_y() + bar.get_height() / 2, f"{low_growth[i]}%", ha="center", va="center", color="black", fontsize=14)

# Labels and title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16)
ax.set_yticks(indices)
ax.set_yticklabels(categories, fontsize=14)
ax.invert_yaxis()  # Labels read top-to-bottom
ax.set_xticks([])

# Legend with new position
ax.legend(loc="upper left", bbox_to_anchor=(0.1, 1.15), ncol=3, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Tight layout
plt.tight_layout()
plt.savefig("bar_138.pdf", bbox_inches="tight")
