
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
categories = ["Abstract", "Realism", "Impressionism", "Cubism", "Surrealism"]
Modern_Art_wins = [70, 55, 65, 80, 60]
Tie = [20, 30, 25, 10, 25]
Classic_Art_wins = [10, 15, 10, 10, 15]

indices = range(len(categories))

labels = ["Modern Art wins", "Tie", "Classic Art wins"]

# Text and labels
xlabel = 'Number of Wins'
ylabel = 'Art Styles'
title = 'Art Competition Results'
legend_labels = ["Modern Art Wins", "Tie", "Classic Art Wins"]

# Optimized text labels for annotations
Modern_Art_text_params = {'ha': 'center', 'va': 'center', 'color': 'white', 'fontsize': 14}
Tie_text_params = {'ha': 'center', 'va': 'center', 'color': 'black', 'fontsize': 14}
Classic_Art_text_params = {'ha': 'center', 'va': 'center', 'color': 'black', 'fontsize': 14}

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
bar_width = 0.5

# Figure size
fig, ax = plt.subplots(figsize=(10, 6))

# Bar chart
bars1 = ax.barh(indices, Modern_Art_wins, bar_width, label=labels[0], color="#ff9999")
bars2 = ax.barh(indices, Tie, bar_width, left=Modern_Art_wins, label=labels[1], color="#66b3ff")
bars3 = ax.barh(indices, Classic_Art_wins, bar_width, left=[i + j for i, j in zip(Modern_Art_wins, Tie)], label=labels[2], color="#99ff99")

# Adding text labels with new positions and font size
for i, bar in enumerate(bars1):
    ax.text(bar.get_width() / 2, bar.get_y() + bar.get_height() / 2, f"{Modern_Art_wins[i]}", **Modern_Art_text_params)
for i, bar in enumerate(bars2):
    ax.text(bar.get_x() + bar.get_width() / 2, bar.get_y() + bar.get_height() / 2, f"{Tie[i]}", **Tie_text_params)
for i, bar in enumerate(bars3):
    ax.text(bar.get_x() + bar.get_width() / 2, bar.get_y() + bar.get_height() / 2, f"{Classic_Art_wins[i]}", **Classic_Art_text_params)

# Labels and title
ax.set_yticks(indices)
ax.set_yticklabels(categories, fontsize=14)
ax.set_xlabel(xlabel, fontsize=16)
ax.set_ylabel(ylabel, fontsize=16)
ax.set_title(title, fontsize=18, pad=20)
ax.invert_yaxis()  # Labels read top-to-bottom
ax.set_xticks([])

# Legend with new position and labels
ax.legend(loc="upper left", bbox_to_anchor=(0.1, 1.2), ncol=3, fontsize=14, labels=legend_labels)

# ===================
# Part 4: Saving Output
# ===================
# Tight layout
plt.tight_layout()
plt.savefig("bar_140.pdf", bbox_inches="tight")
