
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Data for Training Method A
training_method_a_data = {
    "Speed": [5, 15, 25, 35, 20],
    "Strength": [10, 20, 20, 30, 20],
    "Endurance": [5, 10, 30, 35, 20],
    "Flexibility": [20, 25, 15, 20, 20],
}
training_method_a_data2 = {
    "Agility": [10, 20, 25, 25, 20],
}

# Data for Training Method B
training_method_b_data = {
    "Speed": [15, 20, 20, 30, 15],
    "Strength": [10, 15, 30, 25, 20],
    "Endurance": [10, 15, 20, 35, 20],
    "Flexibility": [15, 20, 20, 25, 20],
}
training_method_b_data2 = {"Agility": [5, 20, 20, 35, 20]}

categories = ["Very Poor", "Poor", "Average", "Good", "Excellent"]
categories2 = ["Very Poor", "Poor", "Average", "Good", "Excellent"]

labels = ["Training Method A", "Training Method B"]

# Chart Title and Labels
chart_title = "Comparison of Training Methods Across Metrics"
x_label = "Percentage of Participants"
legend_labels = categories

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#66c2a5", "#fc8d62", "white", "#8da0cb", "#e78ac3"]
xlim = [-69, 69]
xticks = np.arange(-60, 61, 20)
# Create a gridspec
gs = gridspec.GridSpec(3, 2, height_ratios=[1.2, 0.2, 0.2])  # Adjusted height ratios

fig = plt.figure(figsize=(12, 8))

# Create axes using the gridspec
axes = [plt.subplot(gs[0, 0]), plt.subplot(gs[0, 1])]


def create_bar_chart(ax, results, category_names, title):
    labels = list(results.keys())
    data = np.array(list(results.values()))
    data_cum = data.cumsum(axis=1)
    middle_index = data.shape[1] // 2
    offsets = data[:, range(middle_index)].sum(axis=1) + data[:, middle_index] / 2

    # Color Mapping
    category_colors = plt.get_cmap("coolwarm_r")(np.linspace(0.15, 0.85, data.shape[1]))

    # Plot Bars
    for i, (colname, color) in enumerate(zip(category_names, category_colors)):
        widths = data[:, i]
        starts = data_cum[:, i] - widths - offsets
        rects = ax.barh(
            labels,
            widths,
            left=starts,
            height=0.5,
            label=colname,
            color=color,
            edgecolor="black",
        )
        for j, (start, width) in enumerate(zip(starts, widths)):
            # Calculate the center position of each bar segment for the text
            text_x = start + width / 2
            text_y = j  # y-coordinate is based on the bar's index (j)
            ax.text(
                text_x,
                text_y,
                f"{abs(width):.1f}%",
                va="center",
                ha="center",
                color="black",
                fontsize=8,
            )
    # Add Zero Reference Line
    ax.axvline(0, linestyle="-", color="black", alpha=0.25)
    # X Axis
    ax.set_xlim(xlim)
    ax.set_xticks(xticks)
    ax.xaxis.set_major_formatter(lambda x, pos: str(abs(int(x))))
    # Y Axis
    ax.invert_yaxis()
    ax.set_title(title)


# Create bar charts for Training Method A and Training Method B
create_bar_chart(axes[0], training_method_a_data, categories, labels[0])
create_bar_chart(axes[1], training_method_b_data, categories2, labels[1])

# Add legend
handles, labels = axes[0].get_legend_handles_labels()
fig.legend(
    handles,
    labels,
    loc="lower center",
    ncol=len(categories),
    bbox_to_anchor=(0.5, 0.25),
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_141.pdf", bbox_inches="tight")
