
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.ticker as ticker

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)  # For reproducibility

# Sample data
temperature_values = np.linspace(-10, 30, 11)
efficiency_values = np.linspace(0.6, 1, 11)
hour_values = np.linspace(0, 24, 11)

# Sample energy consumption change rates for 'Energy-efficient' and 'Standard'
energy_change_temp_efficient = np.random.uniform(-10, 10, 11)
energy_change_efficiency_efficient = np.random.uniform(-15, 5, 11)
energy_change_hour_efficient = np.random.uniform(-20, 20, 11)

energy_change_temp_standard = np.random.uniform(-10, 10, 11)
energy_change_efficiency_standard = np.random.uniform(-15, 5, 11)
energy_change_hour_standard = np.random.uniform(-20, 20, 11)

# Extracted variables
label_efficient = "Energy-efficient"
label_standard = "Standard"
xlabel_temperature = "Temperature (°C)"
ylabel_energy_change = "Energy Consumption Change [%]"
xlabel_efficiency = "Energy Efficiency Rating"
xlabel_hour = "Hour of the Day"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim_temperature = (-15, 15)
xlim_temperature = (-12, 32)
yticks_temperature = [-15, -10, -5, 0, 5, 10, 15]
xticks_temperature = list(range(-10, 31, 5))
ylim_efficiency = (-20, 10)
xlim_efficiency = (0.58, 1.02)
yticks_efficiency = [-20, -15, -10, -5, 0, 5, 10]
xticks_efficiency = [0.6, 0.7, 0.8, 0.9, 1.0]
ylim_hour = (-25, 25)
xlim_hour = (-2, 26)
yticks_hour = [-25, -20, -15, -10, -5, 0, 5, 10, 15, 20, 25]
xticks_hour = list(range(0, 25, 2))

# Create figure and subplots
fig, axs = plt.subplots(3, 1, figsize=(8, 10))

# Top chart - Temperature
axs[0].bar(
    temperature_values - 0.5,
    energy_change_temp_efficient,
    width=1,
    zorder=10,
    color="#3cb44b",
    edgecolor="black",
    label=label_efficient,
    hatch='/'
)
axs[0].bar(
    temperature_values + 0.5,
    energy_change_temp_standard,
    width=1,
    zorder=10,
    color="#ffa600",
    edgecolor="black",
    label=label_standard,
    hatch='\\'
)
axs[0].set_xlabel(xlabel_temperature)
axs[0].set_ylabel(ylabel_energy_change)
axs[0].set_ylim(ylim_temperature)
axs[0].set_xlim(xlim_temperature)
axs[0].set_yticks(yticks_temperature)
axs[0].xaxis.set_major_locator(ticker.FixedLocator(xticks_temperature))
axs[0].xaxis.set_major_formatter(ticker.FuncFormatter(lambda x, _: f"{int(x)}"))
axs[0].grid(True, which="major", axis="y", color="gray", linestyle='--')
axs[0].tick_params(axis="x", which="major", length=0)

# Middle chart - Energy Efficiency
axs[1].bar(
    efficiency_values - 0.01,
    energy_change_efficiency_efficient,
    width=0.02,
    zorder=10,
    color="#3cb44b",
    edgecolor="black",
    hatch='/'
)
axs[1].bar(
    efficiency_values + 0.01,
    energy_change_efficiency_standard,
    width=0.02,
    zorder=10,
    color="#ffa600",
    edgecolor="black",
    hatch='\\'
)
axs[1].set_xlabel(xlabel_efficiency)
axs[1].set_ylabel(ylabel_energy_change)
axs[1].set_ylim(ylim_efficiency)
axs[1].set_xlim(xlim_efficiency)
axs[1].set_yticks(yticks_efficiency)
axs[1].xaxis.set_major_locator(ticker.FixedLocator(xticks_efficiency))
axs[1].xaxis.set_major_formatter(ticker.FuncFormatter(lambda x, _: f"{x:.1f}"))
axs[1].grid(True, which="major", axis="y", color="gray", linestyle='--')
axs[1].tick_params(axis="x", which="major", length=0)

# Bottom chart - Hour of the Day
axs[2].bar(
    hour_values - 0.5,
    energy_change_hour_efficient,
    width=1,
    zorder=10,
    color="#3cb44b",
    edgecolor="black",
    hatch='/'
)
axs[2].bar(
    hour_values + 0.5,
    energy_change_hour_standard,
    width=1,
    zorder=10,
    color="#ffa600",
    edgecolor="black",
    hatch='\\'
)
axs[2].set_xlabel(xlabel_hour)
axs[2].set_ylabel(ylabel_energy_change)
axs[2].set_ylim(ylim_hour)
axs[2].set_xlim(xlim_hour)
axs[2].set_yticks(yticks_hour)
axs[2].tick_params(axis="x", which="major", length=0)

axs[2].xaxis.set_major_locator(ticker.FixedLocator(xticks_hour))
axs[2].xaxis.set_major_formatter(ticker.FuncFormatter(lambda x, _: f"{int(x)}"))
axs[2].grid(True, which="major", axis="y", color="gray", linestyle='--')

# Add legend
fig.legend(loc="upper center", ncol=2, bbox_to_anchor=(0.5, 1.03), frameon=False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_145.pdf", bbox_inches="tight")
