
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.ticker as ticker

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# New data for the art, design domain
color_contrast_values = np.linspace(0.5, 1.5, 11)
font_size_values = np.linspace(0.75, 1.25, 11)
canvas_rotation_values = np.linspace(-150, 150, 11)

# Sample performance change rates for 'Modern Art' and 'Classical Art'
performance_change_contrast_modern = np.random.uniform(-20, 0, 11)
performance_change_font_modern = np.random.uniform(-30, 10, 11)
performance_change_rotation_modern = np.random.uniform(-15, 30, 11)

performance_change_contrast_classical = np.random.uniform(-25, 5, 11)
performance_change_font_classical = np.random.uniform(-35, 15, 11)
performance_change_rotation_classical = np.random.uniform(-10, 25, 11)

# Labels and axis descriptions
label_modern = "Modern Art"
label_classical = "Classical Art"
xlabel_contrast = "Color Contrast"
ylabel_performance_change = "Performance Change[%]"
xlabel_font = "Font Size"
xlabel_rotation = "Canvas Rotation Angle [°]"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim_contrast = (-25, 5)
xlim_contrast = (0.46, 1.54)
yticks_contrast = [-25, -15, -5, 5]
xticks_contrast = [0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5]
ylim_font = (-35, 15)
xlim_font = (0.73, 1.27)
yticks_font = [-35, -25, -15, -5, 5, 15]
xticks_font = [0.75, 0.8, 0.85, 0.9, 0.95, 1.0, 1.05, 1.1, 1.15, 1.2, 1.25]
ylim_rotation = (-15, 30)
xlim_rotation = (-165, 165)
yticks_rotation = [-15, -5, 5, 15, 25]
xticks_rotation = [-150, -120, -90, -60, -30, 0, 30, 60, 90, 120, 150]

# Create figure and subplots
fig, axs = plt.subplots(3, 1, figsize=(6, 10))

# Top chart - Color Contrast
axs[0].bar(
    color_contrast_values - 0.02,
    performance_change_contrast_modern,
    width=0.04,
    zorder=10,
    color="#e377c2",  # Vibrant pink for modern art
    label=label_modern,
)
axs[0].bar(
    color_contrast_values + 0.02,
    performance_change_contrast_classical,
    width=0.04,
    zorder=10,
    color="#7f7f7f",  # Subtle grey for classical art
    label=label_classical,
)
axs[0].set_xlabel(xlabel_contrast)
axs[0].set_ylabel(ylabel_performance_change)
axs[0].set_ylim(ylim_contrast)
axs[0].set_xlim(xlim_contrast)
axs[0].set_yticks(yticks_contrast)
axs[0].xaxis.set_major_locator(ticker.FixedLocator(xticks_contrast))
axs[0].xaxis.set_major_formatter(ticker.FuncFormatter(lambda x, _: f"{x}"))
offsetticks2 = [0.45] + [i + 0.05 for i in xticks_contrast]
axs[0].xaxis.set_minor_locator(ticker.FixedLocator(offsetticks2))
axs[0].grid(True, which="minor", axis="x", color="gray")
axs[0].grid(True, which="major", axis="y", color="gray")
axs[0].tick_params(axis="x", which="major", length=0)

# Middle chart - Font Size
axs[1].bar(
    font_size_values - 0.01,
    performance_change_font_modern,
    width=0.02,
    zorder=10,
    color="#1f77b4",  # Blue for modern art
)
axs[1].bar(
    font_size_values + 0.01,
    performance_change_font_classical,
    width=0.02,
    zorder=10,
    color="#ff7f0e",  # Orange for classical art
)
axs[1].set_xlabel(xlabel_font)
axs[1].set_ylabel(ylabel_performance_change)
axs[1].set_ylim(ylim_font)
axs[1].set_xlim(xlim_font)
axs[1].set_yticks(yticks_font)
axs[1].xaxis.set_major_locator(ticker.FixedLocator(xticks_font))
axs[1].xaxis.set_major_formatter(ticker.FuncFormatter(lambda x, _: f"{x}"))
offsetticks1 = [0.725] + [i + 0.025 for i in xticks_font]
axs[1].xaxis.set_minor_locator(ticker.FixedLocator(offsetticks1))
axs[1].grid(True, which="minor", axis="x", color="gray")
axs[1].grid(True, which="major", axis="y", color="gray")
axs[1].tick_params(axis="x", which="major", length=0)

# Bottom chart - Canvas Rotation Angle
axs[2].bar(
    canvas_rotation_values - 5,
    performance_change_rotation_modern,
    width=10,
    zorder=10,
    color="#2ca02c",  # Green for modern art
)
axs[2].bar(
    canvas_rotation_values + 5,
    performance_change_rotation_classical,
    width=10,
    zorder=10,
    color="#d62728",  # Red for classical art
)
axs[2].set_xlabel(xlabel_rotation)
axs[2].set_ylabel(ylabel_performance_change)
axs[2].set_ylim(ylim_rotation)
axs[2].set_xlim(xlim_rotation)
axs[2].set_yticks(yticks_rotation)
axs[2].tick_params(axis="x", which="major", length=0)

axs[2].xaxis.set_major_locator(ticker.FixedLocator(xticks_rotation))
axs[2].xaxis.set_major_formatter(ticker.FuncFormatter(lambda x, _: f"{int(x)}"))
offsetticks = [-165, -135, -105, -75, -45, -15, 15, 45, 75, 105, 135, 165]
axs[2].xaxis.set_minor_locator(ticker.FixedLocator(offsetticks))
axs[2].grid(True, which="minor", axis="x", color="gray")
axs[2].grid(True, which="major", axis="y", color="gray")

# Add legend
fig.legend(loc="upper center", ncol=2, bbox_to_anchor=(0.5, 1.03), frameon=False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_146.pdf", bbox_inches="tight")

