
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
countries = ["USA", "China", "India", "Germany", "Brazil", "Japan"]
population_density = [36, 153, 455, 232, 25, 347]
literacy_rate = [99, 96, 74, 99, 93, 99]
life_expectancy = [79, 77, 69, 81, 75, 84]
urbanization_rate = [83, 60, 34, 76, 86, 92]

x = np.arange(len(countries))  # the label locations

labels = ["Population Density", "Literacy Rate", "Life Expectancy", "Urbanization Rate"]
ylabel = "Metrics"
xlabel = "Countries"
title = "Key Population Metrics of Different Countries"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
width = 0.2  # the width of the bars
fig, ax = plt.subplots(figsize=(10, 6))

# Color scheme
colors = ["#4e79a7", "#f28e2b", "#e15759", "#76b7b2"]

# Plotting
rects1 = ax.bar(x - width * 1.5, population_density, width, label=labels[0], color=colors[0])
rects2 = ax.bar(x - width / 2, literacy_rate, width, label=labels[1], color=colors[1])
rects3 = ax.bar(x + width / 2, life_expectancy, width, label=labels[2], color=colors[2])
rects4 = ax.bar(x + width * 1.5, urbanization_rate, width, label=labels[3], color=colors[3])

# Add some text for labels, title and custom x-axis tick labels, etc.
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(countries)
ax.legend()

# Additional Adjustments
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("bar_148.pdf", bbox_inches="tight")
