
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data
tools = ["Zoom", "Microsoft Teams", "Slack", "Google Meet", "Webex", "Skype"]
user_satisfaction = [3.8, 3.5, 3.0, 3.2, 3.6, 2.9]
ease_of_use = [3.7, 3.4, 3.3, 3.2, 3.5, 2.8]
features = [3.6, 3.3, 3.1, 3.0, 3.4, 2.7]
reliability = [3.9, 3.6, 3.2, 3.4, 3.7, 3.0]

x = np.arange(len(tools))  # the label locations

labels = ["User Satisfaction", "Ease of Use", "Features", "Reliability"]
ylabel = "Ratings (1-4)"
xlabel = "Communication Tools"
title = "Ratings of Communication Tools on a Scale from 1-4"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
width = 0.2  # the width of the bars
fig, ax = plt.subplots(figsize=(10, 6))

# Plotting
rects1 = ax.bar(x - width * 1.5, user_satisfaction, width, label=labels[0], color="#4e79a7", edgecolor="black")
rects2 = ax.bar(x - width / 2, ease_of_use, width, label=labels[1], color="#f28e2b", edgecolor="black")
rects3 = ax.bar(x + width / 2, features, width, label=labels[2], color="#e15759", edgecolor="black")
rects4 = ax.bar(x + width * 1.5, reliability, width, label=labels[3], color="#76b7b2", edgecolor="black")

# Add some text for labels, title and custom x-axis tick labels, etc.
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(tools)
ax.legend()

# Enhance visualization
ax.grid(True, which='both', linestyle='--', linewidth=0.5)
ax.set_axisbelow(True)

# Adding rounded edges on the bars
for rect in [rects1, rects2, rects3, rects4]:
    for bar in rect:
        bar.set_linewidth(1.2)
        bar.set_edgecolor('black')
        bar.set_alpha(0.9)
        bar.set_capstyle('round')

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_149.pdf", bbox_inches="tight")
