
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
cities = ["New York", "Los Angeles", "Chicago", "Houston", "Phoenix", "San Francisco", "Seattle", "Miami"]
avg_temp = [12.5, 18.2, 10.2, 20.3, 21.9, 15.4, 11.8, 25.4]

xlabel = "Cities"
ylabel = "Average Monthly Temperature (°C)"
title = "Average Monthly Temperatures in Major US Cities"

xticks = np.arange(len(cities))
ylim = [0, 30]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and bar chart
fig, ax = plt.subplots(figsize=(10, 6))
colors = [
    "#4a90e2",  # New York
    "#50b7c1",  # Los Angeles
    "#55b949",  # Chicago
    "#f8b92d",  # Houston
    "#f48c42",  # Phoenix
    "#e94f37",  # San Francisco
    "#6b2c91",  # Seattle
    "#d8675c",  # Miami
]
bars = ax.bar(cities, avg_temp, color=colors)

# Add temperature values on top of the bars
for bar in bars:
    yval = bar.get_height()
    plt.text(
        bar.get_x() + bar.get_width() / 2,
        yval,
        round(yval, 1),
        ha="center",
        va="bottom",
        fontsize=9,
        fontweight='bold',
        color='#333333'
    )

# Set axis labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks(xticks)
ax.set_xticklabels(cities, rotation=45, ha="right")

ax.set_ylim(ylim)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_151.pdf", bbox_inches="tight")
