
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
sectors = ["Residential", "Commercial", "Industrial", "Transportation"]
electricity = [1200, 0, 0, 0]
natural_gas = [0, 1200, 0, 0]
coal = [0, 0, 800, 0]
renewables = [0, 0, 0, 400]
labels = ["Electricity", "Natural Gas", "Coal", "Renewables"]

# Labels and Titles
xlabel = "Energy Sectors"
ylabel = "Energy Consumption (in TWh)"
title = "Energy Consumption by Sector and Source"
legend_labels = ["Electricity", "Natural Gas", "Coal", "Renewables"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim = [0, 9000]

# Set figure size to be more visually balanced
plt.figure(figsize=(8, 6))

# Plotting
bar_width = 0.8
index = np.arange(len(sectors))

# Color choices
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

plt.bar(index, electricity, bar_width, color=colors[0], label=labels[0])
plt.bar(index, natural_gas, bar_width, color=colors[1], label=labels[1], bottom=electricity)
plt.bar(
    index,
    coal,
    bar_width,
    color=colors[2],
    label=labels[2],
    bottom=[i + j for i, j in zip(electricity, natural_gas)],
)
plt.bar(
    index,
    renewables,
    bar_width,
    color=colors[3],
    label=labels[3],
    bottom=[i + j + k for i, j, k in zip(electricity, natural_gas, coal)],
)

# Labels and Title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.ylim(ylim)
plt.xticks(index, sectors)
plt.legend(legend_labels, loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("bar_158.pdf", bbox_inches="tight")
