
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the bar charts
categories = ["School A", "School B"]
excellent = [0.4, 0.45]
good = [0.3, 0.25]
average = [0.15, 0.15]
below_average = [0.1, 0.1]
poor = [0.03, 0.03]
fail = [0.02, 0.02]

# Calculating the y positions for the bars
y_pos = range(len(categories))

# Labels and axis information
labels = [
    "Excellent",
    "Good",
    "Average",
    "Below Average",
    "Poor",
    "Fail",
]
xlabel = "Percentage of Students"
title = "Performance Distribution Across Schools"
legend_title = "Performance Levels"
bar_width = 0.5
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with a specific size to match the original image's dimensions
fig, ax = plt.subplots(figsize=(10, 5))
# New color scheme
colors = ["#2E7D32", "#0288D1", "#FFD54F", "#FFA000", "#F4511E", "#B71C1C"]
# Stack the bars horizontally
ax.barh(y_pos, excellent, bar_width, color=colors[0], label=labels[0])
ax.barh(
    y_pos,
    good,
    bar_width,
    left=excellent,
    color=colors[1],
    label=labels[1],
)
ax.barh(
    y_pos,
    average,
    bar_width,
    left=[i + j for i, j in zip(excellent, good)],
    color=colors[2],
    label=labels[2],
)
ax.barh(
    y_pos,
    below_average,
    bar_width,
    left=[i + j + k for i, j, k in zip(excellent, good, average)],
    color=colors[3],
    label=labels[3],
)
ax.barh(
    y_pos,
    poor,
    bar_width,
    left=[
        i + j + k + l
        for i, j, k, l in zip(
            excellent, good, average, below_average
        )
    ],
    color=colors[4],
    label=labels[4],
)
ax.barh(
    y_pos,
    fail,
    bar_width,
    left=[
        i + j + k + l + m
        for i, j, k, l, m in zip(
            excellent, good, average, below_average, poor
        )
    ],
    color=colors[5],
    label=labels[5],
)

# Set the y-axis labels
ax.set_yticks(y_pos)
ax.set_yticklabels(categories)

# Set the x-axis label
ax.set_xlabel(xlabel)
ax.set_title(title)

# Add a legend
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.6), ncol=3, frameon=True, title=legend_title)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_159.pdf", bbox_inches="tight")
