
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the bar charts
categories = ["Portfolio A", "Portfolio B"]
roi = [0.25, 0.3]
market_risk = [0.1, 0.05]
inflation_impact = [0.05, 0.1]
management_fees = [0.02, 0.03]
liquidity_risk = [0.03, 0.02]
credit_risk = [0.05, 0.04]

y_pos = range(len(categories))
labels = [
    "ROI",
    "Market Risk",
    "Inflation Impact",
    "Management Fees",
    "Liquidity Risk",
    "Credit Risk",
]
xlabel = "Percentage of Total Allocation"

# Colors for each segment
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]
bar_width = 0.5
# Create a figure with a specific size to match the original image's dimensions
fig, ax = plt.subplots(figsize=(10, 4))

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Stack the bars horizontally
ax.barh(y_pos, roi, bar_width, color=colors[0], label=labels[0])
ax.barh(
    y_pos,
    market_risk,
    bar_width,
    left=roi,
    color=colors[1],
    label=labels[1],
)
ax.barh(
    y_pos,
    inflation_impact,
    bar_width,
    left=[i + j for i, j in zip(roi, market_risk)],
    color=colors[2],
    label=labels[2],
)
ax.barh(
    y_pos,
    management_fees,
    bar_width,
    left=[i + j + k for i, j, k in zip(roi, market_risk, inflation_impact)],
    color=colors[3],
    label=labels[3],
)
ax.barh(
    y_pos,
    liquidity_risk,
    bar_width,
    left=[
        i + j + k + l
        for i, j, k, l in zip(
            roi, market_risk, inflation_impact, management_fees
        )
    ],
    color=colors[4],
    label=labels[4],
)
ax.barh(
    y_pos,
    credit_risk,
    bar_width,
    left=[
        i + j + k + l + m
        for i, j, k, l, m in zip(
            roi, market_risk, inflation_impact, management_fees, liquidity_risk
        )
    ],
    color=colors[5],
    label=labels[5],
)

# Set the y-axis labels
ax.set_yticks(y_pos)
ax.set_yticklabels(categories)

# Set the x-axis label
ax.set_xlabel(xlabel)

# Add a legend
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.3), ncol=3, frameon=False)

# Title
plt.title("Performance Distribution of Investment Portfolios")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with a tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_161.pdf", bbox_inches="tight")
