
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# New Data
datasets = ["Urban Area", "Rural Area"]
transmission_5g = [0.8, 1.2]
transmission_wifi6 = [1.0, 1.8]
transmission_starlink = [2.5, 3.0]

# X-axis positions
x = np.arange(len(datasets))

# Labels and Titles
labels = ["5G", "Wi-Fi 6", "Starlink"]
ylabel = "Transmission Delay (ms)"
xlabel = "Scenarios"
title = "Transmission Delay Across Different Communication Methods"
legendlocation = "upper left"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
width = 0.2
ylim = [0, 4.0]

# Color Scheme
colors = ["#1f77b4", "#ff7f0e", "#2ca02c"]

# Plotting
fig, ax = plt.subplots(figsize=(6, 5))

ax.bar(
    x - width,
    transmission_5g,
    width,
    label=labels[0],
    hatch="//",
    edgecolor="black",
    color=colors[0],
)
ax.bar(
    x,
    transmission_wifi6,
    width,
    label=labels[1],
    hatch="..",
    edgecolor="black",
    color=colors[1],
)
ax.bar(
    x + width,
    transmission_starlink,
    width,
    label=labels[2],
    hatch="xx",
    edgecolor="black",
    color=colors[2],
)

# Labels and Title
ax.set_ylim(ylim)
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(datasets)
ax.legend(loc=legendlocation)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_162.pdf", bbox_inches="tight")
