
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
years = ["2010", "2015", "2020"]
country_a = [50, 55, 60]  # Population in millions
country_b = [45, 50, 65]
country_c = [40, 45, 55]

# X-axis positions
x = np.arange(len(years))

# Labels and Titles
labels = ["Country A", "Country B", "Country C"]
ylabel = "Population (Millions)"
xlabel = "Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
width = 0.2
ylim = [0, 70]

# Plotting
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusting figure size
ax.bar(x - width, country_a, width, label=labels[0], hatch="//", edgecolor="black", color="#99d8c9")
ax.bar(x, country_b, width, label=labels[1], hatch="..", edgecolor="black", color="#fc9272")
ax.bar(x + width, country_c, width, label=labels[2], hatch="xx", edgecolor="black", color="#9ecae1")

# Labels and Title
ax.set_ylim(ylim)
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_xticks(x)
ax.set_xticklabels(years)
ax.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_164.pdf", bbox_inches="tight")
