
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
financial_instruments = ["Stocks", "Bonds", "Commodities", "Real Estate"]
returns_2000s = [5.8, 4.2, 3.5, 6.0]
returns_2010s = [7.1, 3.8, 2.2, 5.4]
returns_2020s = [8.5, 3.3, 4.1, 6.9]

x = np.arange(len(financial_instruments))  # the label locations

# Labels for legend
label_2000s = "2000s"
label_2010s = "2010s"
label_2020s = "2020s"

# Axis labels
xlabel = "Financial Instruments"
ylabel = "Average Annual Return (%)"

# Chart Title
title = "Average Annual Returns of Financial Instruments (2000s, 2010s, 2020s)"
width = 0.25  # the width of the bars
# Axis ticks
xticks = x
yticks = [0, 2, 4, 6, 8, 10]

# Axis tick labels
xticklabels = financial_instruments
yticklabels = ["0%", "2%", "4%", "6%", "8%", "10%"]
# ===================
# Part 3: Plot Configuration and Rendering
# ===================


fig, ax = plt.subplots(figsize=(10, 6))
rects1 = ax.bar(x - width, returns_2000s, width, label=label_2000s, color="#4caf50")  # Green shade
rects2 = ax.bar(x, returns_2010s, width, label=label_2010s, color="#2196f3")  # Blue shade
rects3 = ax.bar(x + width, returns_2020s, width, label=label_2020s, color="#ffeb3b")  # Gold shade

ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_yticks(yticks)
ax.set_yticklabels(yticklabels)

# Adding gridlines for better readability
ax.grid(True, which='both', linestyle='--', linewidth=0.5, color='gray', alpha=0.7)

# Legend
ax.legend(ncol=3, loc="upper center", bbox_to_anchor=(0.5, 1.1), frameon=False)

# Removing axis ticks for a cleaner look
ax.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_165.pdf", bbox_inches="tight")

