
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
categories = [
    "Fantasy vs. Science Fiction",
    "Mystery vs. Thriller",
    "Romance vs. Drama",
    "Non-Fiction vs. Memoir",
    "Young Adult vs. Children's",
    "Classic vs. Modern Fiction",
][::-1]

popularity = [35.0, 42.0, 58.0, 40.5, 45.5, 30.5][::-1]
critical_acclaim = [30.0, 25.5, 20.0, 33.0, 32.0, 38.0][::-1]
readability = [35.0, 32.5, 22.0, 26.5, 22.5, 31.5][::-1]

labels = ["Popularity", "Critical Acclaim", "Readability"]

indices = range(len(categories))

# Chart text labels
xticks = [0, 20, 40, 60, 80, 100]
xtickslabel = ["0", "20", "40", "60", "80", "100"]
bar_width = 0.6
xlabel = 'Percentage (%)'
ylabel = 'Genre Comparisons'
title = 'Comparison of Different Literature Genres'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create stacked bar chart
fig, ax = plt.subplots(figsize=(10, 6))  # Adjust figure size to 720x432 pixels

bars1 = ax.barh(indices, popularity, bar_width, label=labels[0], color="#5b9bd5")
bars2 = ax.barh(indices, critical_acclaim, bar_width, left=popularity, label=labels[1], color="#ed7d31")
bars3 = ax.barh(
    indices,
    readability,
    bar_width,
    left=[i + j for i, j in zip(popularity, critical_acclaim)],
    label=labels[2],
    color="#70ad47",
)

# Add text labels to the bars
for bars, color in zip([bars1, bars2, bars3], ["#5b9bd5", "#ed7d31", "#70ad47"]):
    for bar in bars:
        width = bar.get_width()
        center = bar.get_x() + width / 2
        ax.text(
            center,
            bar.get_y() + bar.get_height() / 2,
            f"{width:.1f}%",
            va="center",
            ha="center",
            color="black",
            fontsize=10,
        )

# Set the y-axis labels
ax.set_yticks(indices)
ax.set_yticklabels(categories, ha="right")

# Set the x-axis labels
ax.set_xticks(xticks)
ax.set_xticklabels(xtickslabel)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Add legend
ax.legend(
    loc="upper center", bbox_to_anchor=(0.5, 1.1), shadow=True, ncol=3, frameon=False
)

# Remove spines
for spine in ["top", "right"]:
    ax.spines[spine].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_172.pdf", bbox_inches="tight")
