
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
categories = ["GDP Growth", "Inflation Rate", "Unemployment Rate"]
values = [2.4, 1.7, 5.1]

# Axes limits, labels, and ticks
xlabel = "Percentage"
title = "Key Economic Indicators"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks = [0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0]
xtickslabel = ["0%", "1%", "2%", "3%", "4%", "5%", "6%"]

# Create horizontal bar chart
plt.figure(figsize=(8, 4))  # Adjusting figure size for clarity
plt.barh(categories, values, color=['#2c7bb6', '#abd9e9', '#a6d96a'])

# Adding data labels
for index, value in enumerate(values):
    plt.text(value, index, f" {value}%", va="center", color="black")

# Adding title and labels
plt.title(title, fontsize=14, fontweight='bold')
plt.xlabel(xlabel, fontsize=12)
# Apply the xticks and labels
plt.xticks(xticks, xtickslabel)

# Style adjustments
plt.tick_params(axis="both", which="both", length=0)
plt.grid(axis='x', linestyle='--', linewidth=0.7, color='gray')

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("bar_174.pdf", bbox_inches="tight")
