
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
categories = ["Watch TV", "Listen to Radio", "Read Newspapers"]
values = [0.65, 0.55, 0.30]

# Axes limits, labels, and ticks
xlabel = "Probability of Media Consumption"
title = "Probability of Media Consumption in Modern Age"
xticks = [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0]
xtickslabel = ["0.0", "", "0.2", "", "0.4", "", "0.6", "", "0.8", "", "1.0"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart
plt.figure(figsize=(8, 4))  # Adjusted figure size for better visualization
colors = ["#ff9999", "#66b3ff", "#99ff99"]  # Custom colors for the bars
plt.barh(categories, values, color=colors)

# Adding data labels
for index, value in enumerate(values):
    plt.text(value, index, f" {value:.2f}", va="center", color="black")

# Adding title and labels
plt.title(title, fontsize=14, fontweight='bold')
plt.xlabel(xlabel, fontsize=12)

# Apply the xticks and labels
plt.xticks(xticks, xtickslabel)

plt.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("bar_175.pdf", bbox_inches="tight")
