
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
years = ["2018", "2019", "2020", "2021", "2022"]
co2_emissions = [400, 420, 430, 390, 410]
water_pollution_index = [76, 80, 79, 75, 78]
air_quality_index = [65, 68, 64, 66, 67]

# X-axis positions for each group of bars
x = np.arange(len(years))

labels = [
    "CO2 Emissions (in ppm)",
    "Water Pollution Index",
    "Air Quality Index",
]
title = "Annual Pollution Index Across Different Years"
xlabel = "Years"
ylabel = "Index Values"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
bar_width = 0.25

# Adjust yticks based on the new data range.
yticks = np.arange(0, 501, 50)

# Figure and axis
fig, ax = plt.subplots(figsize=(12, 6))  # Adjusted dimension for clarity

# Plotting bars
rects1 = ax.bar(
    x - bar_width,
    co2_emissions,
    bar_width,
    label=labels[0],
    color="#2f4b7c",
    edgecolor="white",
)
rects2 = ax.bar(
    x,
    water_pollution_index,
    bar_width,
    label=labels[1],
    color="#a05195",
    edgecolor="white",
)
rects3 = ax.bar(
    x + bar_width,
    air_quality_index,
    bar_width,
    label=labels[2],
    color="#d45087",
    edgecolor="white",
)

# Adding index labels on top of each bar
def add_labels(rects):
    for rect in rects:
        height = rect.get_height()
        ax.annotate(
            f"{height:.1f}",
            xy=(rect.get_x() + rect.get_width() / 2, height),
            xytext=(0, 3),  # 3 points vertical offset
            textcoords="offset points",
            ha="center",
            va="bottom",
        )

add_labels(rects1)
add_labels(rects2)
add_labels(rects3)

# Title and labels
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# X and Y ticks
ax.set_xticks(x)
ax.set_xticklabels(years)
ax.set_yticks(yticks)

# Legend
ax.legend(loc="upper center", ncol=3, frameon=False)

# Grid lines
ax.yaxis.grid(True, linestyle='--', linewidth=0.7)
ax.set_axisbelow(True)

grid_color = "#bdbdbd"
# Set border color
for spine in ax.spines.values():
    spine.set_edgecolor(grid_color)
# hidden ticks
plt.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("bar_177.pdf", bbox_inches="tight")
