
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
months = ["Jan", "Feb", "Mar", "Apr", "May"]
avg_temp = [5.2, 6.8, 12.5, 15.3, 20.7]  # Average Temperatures (°C)
precipitation_rate = [78, 54, 60, 45, 72]  # Precipitation (mm)
humidity_rate = [68, 70, 65, 58, 55]  # Humidity (%)

# X-axis positions for each group of bars
x = np.arange(len(months))

# Labels and Titles
labels = [
    "Average Temperature (°C)",
    "Precipitation (mm)",
    "Humidity (%)",
]
title = "Average Monthly Climate Data"
xlabel = "Months"
ylabel = "Values"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
bar_width = 0.25

yticks = np.arange(0, 101, 20)

# Figure and axis
fig, ax = plt.subplots(figsize=(10, 5))

# Plotting bars
rects1 = ax.bar(
    x - bar_width,
    avg_temp,
    bar_width,
    label=labels[0],
    color="#4c72b0",  # Blue for temperature
    edgecolor="white",
)
rects2 = ax.bar(
    x,
    precipitation_rate,
    bar_width,
    label=labels[1],
    color="#dd8452",  # Orange for precipitation
    edgecolor="white",
)
rects3 = ax.bar(
    x + bar_width,
    humidity_rate,
    bar_width,
    label=labels[2],
    color="#55a868",  # Green for humidity
    edgecolor="white",
)

# Adding percentage labels on top of each bar
def add_labels(rects):
    for rect in rects:
        height = rect.get_height()
        ax.annotate(
            f"{height:.1f}",
            xy=(rect.get_x() + rect.get_width() / 2, height),
            xytext=(0, 3),  # 3 points vertical offset
            textcoords="offset points",
            ha="center",
            va="bottom",
        )

add_labels(rects1)
add_labels(rects2)
add_labels(rects3)

# Title and labels
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# X and Y ticks
ax.set_xticks(x)
ax.set_xticklabels(months)
ax.set_yticks(yticks)

# Legend
ax.legend(loc="upper left", ncol=1, frameon=False)

# Grid lines
ax.yaxis.grid(True)
ax.set_axisbelow(True)

grid_color = "#bdbdbd"
# Set border color
for spine in ax.spines.values():
    spine.set_edgecolor(grid_color)
# hidden ticks
plt.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("bar_178.pdf", bbox_inches="tight")
