
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
categories = [
    "Wall Insulation",
    "Roof Insulation",
    "Energy-efficient Windows",
    "LED Lighting",
    "Solar Panels",
    "Energy Star Appliances",
    "Programmable Thermostats",
    "Smart Meters",
    "Weather Stripping",
    "Geothermal Heating",
    "Low-flow Showerheads",
    "Energy-efficient HVAC",
    "Reflective Roofing",
    "Wind Turbines",
    "Variable Speed Drives",
    "Biomass Heating",
    "Hydropower",
    "Smart Grid",
    "Passive Solar Design",
    "Building Automation",
    "Energy Audits",
    "Avg",
]
# Generate three lists
Insulation, Efficient_Lighting, Renewable_Energy = np.random.dirichlet(np.ones(3), size=len(categories)).T

Insulation = Insulation * 100
Efficient_Lighting = Efficient_Lighting * 100
Renewable_Energy = Renewable_Energy * 100

r = np.arange(len(categories))
labels = ["Insulation", "Efficient Lighting", "Renewable Energy"]

# Axis Labels and Title
xlabel = "Energy Efficiency Measures"
ylabel = "Implementation (%)"
title = "Implementation of Various Energy Efficiency Measures"
legend_labels = ["Insulation", "Efficient Lighting", "Renewable Energy"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Stacked bar chart setup
bar_width = 0.9
# Plot
fig, ax = plt.subplots(figsize=(10, 6))
bar1 = ax.bar(
    r,
    Insulation,
    color="#76c893",
    edgecolor="black",
    hatch="\\\\\\",
    width=bar_width,
    label=labels[0],
)
bar2 = ax.bar(
    r,
    Efficient_Lighting,
    bottom=Insulation,
    color="#ffd700",
    edgecolor="black",
    hatch="--",
    width=bar_width,
    label=labels[1],
)
bar3 = ax.bar(
    r,
    Renewable_Energy,
    bottom=Insulation + Efficient_Lighting,
    color="#1f77b4",
    edgecolor="black",
    hatch="++",
    width=bar_width,
    label=labels[2],
)

# Labels, title and legend
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14)

ax.set_xticks(r)
ax.set_xticklabels(categories, rotation=-45, ha="left", fontsize=10)
ax.set_yticks(np.arange(0, 101, 20))
ax.set_ylim(0, 100)
ax.set_yticklabels(["{}%".format(i) for i in range(0, 101, 20)])
ax.legend(labels=legend_labels, loc="upper center", bbox_to_anchor=(0.5, 1.2), ncol=3, fontsize=10)

# Grid lines
ax.yaxis.grid(True, linestyle="--")

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("bar_180.pdf", bbox_inches="tight")
