
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
areas = [1, 2]  # Represents Urban and Rural areas
co2_concentration = [400, 300]  # CO2 concentration in ppm
no2_concentration = [30, 15]  # NO2 concentration in ppb
regulatory_limit = 350  # Regulatory limit for CO2 in ppm

labels = ["CO2 Concentration", "NO2 Concentration"]
xlabel = "Environmental Areas"
ylabel = "Pollutant Concentration"
title = "Pollutant Concentration in Various Areas"
axlabels = "Regulatory Limit for CO2"

ylim = [0, 450]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(
    figsize=(8, 6)
)
bar_width = 0.35
index = np.arange(len(areas))

bar1 = ax.bar(index, co2_concentration, bar_width, label=labels[0], color="#4CAF50")
bar2 = ax.bar(
    index + bar_width, no2_concentration, bar_width, label=labels[1], color="#2196F3"
)

# Adding the text on the bars
for rect in bar1 + bar2:
    height = rect.get_height()
    ax.text(
        rect.get_x() + rect.get_width() / 2.0,
        height,
        "%.2f" % height,
        ha="center",
        va="bottom",
    )

# Regulatory Limit Line
ax.axhline(y=regulatory_limit, color="red", linestyle="--", label=axlabels)

# Labels, title and legend
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_ylim(ylim)
ax.set_xticks(index + bar_width / 2)
ax.set_xticklabels(['Urban', 'Rural'])
ax.legend(loc="upper right")
grid_color = "#d2d2d2"
ax.yaxis.grid(True, linestyle='--', linewidth=0.7)
ax.set_axisbelow(True)

# Set border color
for spine in ax.spines.values():
    spine.set_edgecolor(grid_color)

plt.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout
plt.tight_layout()
plt.savefig("bar_186.pdf", bbox_inches="tight")
