
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data
conditions = [2022, 2023]
method_a = [85.2, 87.1]
method_b = [82.6, 84.3]
baseline_efficiency = 80.0

labels = ["Method A", "Method B"]
xlabel = "Year"
ylabel = "Energy Efficiency (%)"
title = "Energy Efficiency by Year"
axlabels = "Baseline Efficiency"

ylim = [75, 90]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(
    figsize=(6.61, 5.23)
)  
bar_width = 0.35
index = np.arange(len(conditions))

bar1 = ax.bar(index, method_a, bar_width, label=labels[0], color="#76b041")
bar2 = ax.bar(
    index + bar_width, method_b, bar_width, label=labels[1], color="#f28e2b"
)

# Adding the text on the bars
for rect in bar1 + bar2:
    height = rect.get_height()
    ax.text(
        rect.get_x() + rect.get_width() / 2.0,
        height,
        "%.1f" % height,
        ha="center",
        va="bottom",
    )

# Baseline Efficiency Line
ax.axhline(y=baseline_efficiency, color="red", linestyle="--", label=axlabels)

# Labels, title and legend
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
# ax.set_title(title)
ax.set_ylim(ylim)
ax.set_xticks(index + bar_width / 2)
ax.set_xticklabels(conditions)
ax.legend(loc="upper left")  
grid_color = "#b2b2b2"
ax.yaxis.grid(True)
ax.set_axisbelow(True)
# Set border color
for spine in ax.spines.values():
    spine.set_edgecolor(grid_color)

plt.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout
plt.tight_layout()
plt.savefig("bar_188.pdf", bbox_inches="tight")
