
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Data for literature domain
genres = ["Fiction", "Non-fiction", "Mystery", "Fantasy", "Sci-fi", "Poetry"]
popularity_score = [85, 70, 75, 90, 60, 50]
critical_acclaim = [80, 85, 65, 70, 55, 60]
average_sales = [150, 80, 90, 130, 70, 40]
reader_engagement = [95, 60, 80, 110, 50, 30]

# Bar positions
x = np.arange(len(genres))
labels = [
    "Popularity Score",
    "Critical Acclaim",
    "Average Sales (in thousands)",
    "Reader Engagement",
]
xlabel = "Genres"
ylabel = "Metrics"
title = "Literary Genre Analysis"
ylim = [0, 160]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
width = 0.2  # Adjusted width for spacing
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusted to a larger dimension

ax.bar(x - width * 1.5, popularity_score, width, label=labels[0], color="#FFB6C1")
ax.bar(x - width / 2, critical_acclaim, width, label=labels[1], color="#ADD8E6")
ax.bar(x + width / 2, average_sales, width, label=labels[2], color="#90EE90")
ax.bar(x + width * 1.5, reader_engagement, width, label=labels[3], color="#FFD700")

# Labels and Title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(genres)
ax.set_ylim(ylim)

# Legend
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_192.pdf", bbox_inches="tight")
