
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for educational domain
np.random.seed(0)
models = ["Model A", "Model B", "Model C", "Model D", "Model E", "Model F"]
correct = [45, 55, 50, 60, 65, 70]
partially_correct = [30, 25, 35, 40, 30, 20]
incorrect = [20, 15, 10, 5, 5, 5]
skipped = [5, 5, 5, 5, 0, 5]

# Bar positions
x = np.arange(len(models))
labels = [
    "Correct",
    "Partially Correct",
    "Incorrect",
    "Skipped",
]
ylabel = "Percentage"
title = "Performance on Student Assessments"
xlabel = "Models"
ylim = [0, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
width = 0.2  # Adjusted width for spacing

# Plotting
fig, ax = plt.subplots(
    figsize=(7, 5)
)  # Adjusted to match the image dimensions (504x360)

# Choosing a new color scheme tailored for education domain
ax.bar(x - 1.5 * width, correct, width, label=labels[0], color="#66c2a5")  # Green
ax.bar(
    x - 0.5 * width,
    partially_correct,
    width,
    label=labels[1],
    color="#fc8d62",
    hatch="x",
)  # Orange, with cross hatch
ax.bar(x + 0.5 * width, incorrect, width, label=labels[2], color="#8da0cb")  # Blue
ax.bar(
    x + 1.5 * width,
    skipped,
    width,
    label=labels[3],
    color="#e78ac3",
    hatch="/",
)  # Pink, with slant hatch

# Labels and Title
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_xticks(x)
ax.set_xticklabels(models)
ax.set_ylim(ylim)  # Adjusted y-axis limit

# Move legend inside the plot area
ax.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_194.pdf", bbox_inches="tight")
