
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
categories = ["Renaissance", "Baroque", "Impressionism", "Modernism", "Contemporary"][::-1]
historic_significance = [55, 45, 65, 55, 45][::-1]
public_interest = [60, 70, 80, 60, 85][::-1]
market_value = [50, 60, 70, 80, 90][::-1]

labels = ["Historic Significance", "Public Interest", "Market Value"]
y_pos = range(len(categories))

xlabel = 'Metrics Distribution'
ylabel = 'Art Movements'
title = 'Comparison of Art Movements Across Different Metrics'
legendlabels = ["Historic Significance", "Public Interest", "Market Value"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
bar_width = 0.5
# Stacked Bar Chart
fig, ax = plt.subplots(figsize=(10, 6))

ax.barh(y_pos, historic_significance, bar_width, color="#6a9fb5", label=labels[0])
ax.barh(y_pos, public_interest, bar_width, left=historic_significance, color="#b5e1ad", label=labels[1])
ax.barh(
    y_pos,
    market_value,
    bar_width,
    left=[i + j for i, j in zip(historic_significance, public_interest)],
    color="#e18942",
    label=labels[2],
)

# Adding the numerical values within each segment
for i in range(len(categories)):
    ax.text(
        historic_significance[i] / 2,
        i,
        str(historic_significance[i]),
        ha="center",
        va="center",
        color="white",
    )
    ax.text(
        historic_significance[i] + public_interest[i] / 2,
        i,
        str(public_interest[i]),
        ha="center",
        va="center",
        color="black",
    )
    ax.text(
        historic_significance[i] + public_interest[i] + market_value[i] / 2,
        i,
        str(market_value[i]),
        ha="center",
        va="center",
        color="white",
    )

# Labels and Legend
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks([])
ax.set_yticks(y_pos)
ax.set_yticklabels(categories)
ax.legend(loc="upper right", labels=legendlabels)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_195.pdf", bbox_inches="tight")
