
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
categories = [
    "Character Development",
    "Plot Complexity",
    "Thematic Depth",
    "Narrative Pace",
    "Imagery Use",
    "Dialogue Realism",
    "Symbolism",
    "Conflict",
    "Character Arcs",
    "Setting Description",
    "Point of View",
    "Foreshadowing",
    "Protagonist's Journey",
    "Antagonist's Role",
    "Genre Adherence",
    "Moral Questions",
    "Subplots",
    "Climax"
]
differences = [
    -15,
    25,
    -10,
    5,
    -5,
    10,
    20,
    -20,
    30,
    -30,
    -25,
    15,
    35,
    -10,
    45,
    55,
    60,
    70,
]

title = "Relative Difference in Machine vs. Human Focus on Literary Elements"
xlabel = "Difference (%)"
ylabel = "Literary Element"
xlim = [-40, 80]
xticks = range(-40, 81, 20)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#8c564b" if x < 0 else "#2ca02c" for x in differences]
# Create figure and plot
fig, ax = plt.subplots(figsize=(10, 5))
bars = ax.barh(categories, differences, color=colors)

# Highlight specific bars with patterns for emphasis
for bar in bars:
    if bar.get_width() > 0:
        bar.set_hatch('//')

# Set title and labels
ax.set_title(title, fontsize=14, weight='bold')
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)

# Set x-axis limits and labels
ax.set_xlim(xlim)
ax.set_xticks(xticks)
ax.xaxis.grid(True, linestyle='--', alpha=0.7)

# Improve overall layout and readability
plt.gca().invert_yaxis()  # Invert y-axis to have the highest values on top

# ===================
# Part 4: Saving Output
# ===================
# Save the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_198.pdf", bbox_inches="tight")
