
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
categories = [
    "Composition",
    "Color Theory",
    "Sketching",
    "Digital Art",
    "Typography",
    "Photo Editing",
    "3D Modeling",
    "Motion Graphics",
    "Vector Art",
    "Print Design",
    "Logo Design",
    "Illustration",
    "Concept Art",
    "User Interface",
    "User Experience",
    "Branding",
    "Animation",
    "Packaging Design",
]
differences = [
    50,
    40,
    -10,
    70,
    -20,
    30,
    80,
    -30,
    60,
    -40,
    90,
    100,
    -50,
    110,
    120,
    -60,
    130,
    140,
]

title = "Time Spent on Art and Design Activities: Human vs. Machine"
xlabel = "Difference in Time (%)"
ylabel = "Art and Design Activity"
xlim = [-70, 150]
xticks = range(-70, 151, 30)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#ff9999" if x < 0 else "#66b3ff" for x in differences]

# Create figure and plot
fig, ax = plt.subplots(figsize=(12, 7))
ax.barh(categories, differences, color=colors, alpha=0.7)

# Set title and labels
ax.set_title(title, fontsize=16, fontweight='bold', color='#333333')
ax.set_xlabel(xlabel, fontsize=14, fontweight='medium', color='#333333')
ax.set_ylabel(ylabel, fontsize=14, fontweight='medium', color='#333333')

# Set x-axis limits and labels
ax.set_xlim(xlim)
ax.set_xticks(xticks)
ax.xaxis.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Save the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_200.pdf", bbox_inches="tight")
