
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the bar charts
classical_recall = np.array(
    [
        [72, 68, 59],
        [65, 60, 55],
        [58, 53, 49],
        [45, 42, 38],
        [35, 30, 28],
    ]
)
modern_recall = np.array(
    [
        [15, 20, 22],
        [35, 40, 38],
        [45, 50, 48],
        [55, 60, 58],
        [65, 70, 68],
    ]
)
x = [0, 1, 2]

# Titles for subplots
titles = [
    "Period 1: 600 BC - 100 AD",
    "Period 2: 100 AD - 500 AD",
    "Period 3: 500 AD - 1500 AD",
    "Period 4: 1500 AD - 1800 AD",
    "Period 5: 1800 AD - Present",
]

xlabel = "Time Period"
ylabel = "Recall (%)"
labels = ["Classical Recall", "Modern Recall"]
ylim = [-80, 80]
xticks = [0, 1, 2]
xticklabels = ["Philosopher A", "Philosopher B", "Philosopher C"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(14, 4))

# Create subplots
for i in range(5):
    ax = plt.subplot(1, 5, i + 1)
    ax.bar(x, classical_recall[i], width=0.5, label=labels[0], color="#1f77b4")  # Blue color
    ax.bar(x, -modern_recall[i], width=0.5, label=labels[1], color="#ff7f0e")   # Orange color
    ax.set_title(titles[i])
    ax.set_ylim(ylim)
    ax.set_xticks(xticks)
    ax.set_xticklabels(xticklabels)
    # ax.axhline(0, color='black', linewidth=0.8)
    ax.yaxis.grid(True, linestyle="--")
    ax.set_axisbelow(True)

    # Annotate bars with their values
    for j in range(3):
        ax.text(
            x[j], classical_recall[i][j] - 5, str(classical_recall[i][j]), ha="center"
        )
        ax.text(
            x[j],
            -modern_recall[i][j] + 5,
            str(modern_recall[i][j]),
            ha="center",
        )

# Add legend to the first subplot
plt.subplot(1, 5, 1).legend(loc="lower right", frameon=False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_201.pdf", bbox_inches="tight")
